/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uds.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.hotent.base.context.BaseContext;
import com.hotent.base.enums.ExtendJarType;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExtendClassLoader;
import com.hotent.uc.model.Role;
import com.hotent.uds.base.service.IUserGetter;
import com.hotent.uds.base.vo.ArgsVo;
import com.hotent.uds.base.vo.OrgJobVo;
import com.hotent.uds.base.vo.OrgPostVo;
import com.hotent.uds.base.vo.OrgVo;
import com.hotent.uds.base.vo.ParamsVo;
import com.hotent.uds.base.vo.RoleVo;
import com.hotent.uds.base.vo.UserVo;
import com.hotent.uds.manager.UcBatchSyncManager;
import com.hotent.uds.manager.UserSetter;
import com.hotent.uds.manager.UserSync;
import com.hotent.uds.model.UcBatchSync;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;

@Service
public class UserSyncImpl
implements UserSync {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private UcBatchSyncManager ucBatchSyncManager;
    @Resource
    private UserSetter userSetter;
    @Autowired
    MultiTenantHandler multiTenantHandler;
    @Resource
    BpmRuntimeFeignService bpmRuntimeFeignService;

    @Override
    public void executeOne(Map<String, Object> args) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("\u6267\u884c\u4e00\u6b21\u7528\u6237\u6570\u636e\u540c\u6b65");
        UcBatchSync ucBatchSync = this.ucBatchSyncManager.createByXid();
        ArgsVo argsVo = new ArgsVo();
        argsVo.setxId(ucBatchSync.getId());
        argsVo.setLastExcuteTime(ucBatchSync.getLastExecuteTime());
        argsVo.setVars(args);
        boolean result = true;
        IUserGetter userGetter = this.getBeanUserGetter();
        if (userGetter == null) {
            this.logger.error("\u672a\u83b7\u53d6\u5230jar\u5305\u4e2d\u7684\u7528\u6237\u62c9\u53d6\u7c7b\u5e93\uff0c\u65e0\u6cd5\u540c\u6b65\u7528\u6237\u6570\u636e\uff01");
            return;
        }
        try {
            BaseContext context = (BaseContext)AppUtil.getBean(BaseContext.class);
            context.setTempTenantId("-1");
            List orgJobVoList = userGetter.getJobs(argsVo);
            List orgVoList = userGetter.getOrgs(argsVo);
            List orgPostVoList = userGetter.getPosts(argsVo);
            List roleVoList = userGetter.getRoles(argsVo);
            List userVoList = userGetter.getUsers(argsVo);
            List paramVoList = userGetter.getParams(argsVo);
            UserSyncImpl userSync = (UserSyncImpl)AppUtil.getBean(UserSyncImpl.class);
            userSync.setData(orgJobVoList, orgVoList, orgPostVoList, roleVoList, userVoList, paramVoList);
        }
        catch (Exception e) {
            this.logger.error("\u62c9\u53d6\u6570\u636e\u5f02\u5e38\uff01", (Throwable)e);
            result = false;
        }
        userGetter.callback(argsVo, Boolean.valueOf(result));
        ucBatchSync.setStatus(result ? 1 : 2);
        this.ucBatchSyncManager.update((Model)ucBatchSync);
        if (result) {
            this.ucBatchSyncManager.removeByDays(7);
        }
        stopWatch.stop();
        this.logger.info("\u6267\u884c\u7ed3\u679c\uff1a{}", (Object)result);
        this.logger.info(stopWatch.prettyPrint());
    }

    @Transactional(rollbackFor={Exception.class})
    public void setData(List<OrgJobVo> orgJobVoList, List<OrgVo> orgVoList, List<OrgPostVo> orgPostVoList, List<RoleVo> roleVoList, List<UserVo> userVoList, List<ParamsVo> paramVoList) throws Exception {
        this.userSetter.setJobs(orgJobVoList);
        this.userSetter.setOrgs(orgVoList);
        this.userSetter.setPosts(orgPostVoList);
        this.userSetter.setRoles(roleVoList, new ArrayList<Role>());
        this.userSetter.setUsers(userVoList);
        this.userSetter.setParams(paramVoList);
    }

    private IUserGetter getBeanUserGetter() {
        try {
            ArrayNode arrayNode = this.bpmRuntimeFeignService.getJarByType(ExtendJarType.USER_SYNC.getCode());
            if (arrayNode == null || arrayNode.isEmpty()) {
                this.logger.error("\u83b7\u53d6jar\u5305\u4fe1\u606f\u4e3a\u7a7a\uff0c\u672a\u4e0a\u4f20\u6269\u5c55jar\u5305\uff01");
                return null;
            }
            ArrayList<Map> listJarClass = new ArrayList<Map>();
            for (JsonNode jarNode : arrayNode) {
                if (jarNode.get("jarData") == null) continue;
                byte[] jarBytes = jarNode.get("jarData").asText().getBytes(StandardCharsets.ISO_8859_1);
                Map resolutionJarClass = null;
                try {
                    resolutionJarClass = ExtendClassLoader.resolutionJarClass((byte[])jarBytes, (Integer)ExtendJarType.USER_SYNC.getCode());
                    if (!BeanUtils.isNotEmpty((Object)resolutionJarClass)) continue;
                    listJarClass.add(resolutionJarClass);
                }
                catch (NullPointerException e) {
                    this.logger.error("\u6587\u4ef6\u4e0d\u5408\u6cd5\uff01", (Throwable)e);
                }
                catch (Exception e) {
                    this.logger.error("\u6587\u4ef6\u8f6c\u7c7b\u5b57\u8282\u7801\u5f02\u5e38\uff01", (Throwable)e);
                }
            }
            if (CollectionUtils.isNotEmpty(listJarClass)) {
                ExtendClassLoader.registerBean(listJarClass, (boolean)false);
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6jar\u5305\u4e2d\u7684\u7528\u6237\u62c9\u53d6\u7c7b\u5e93\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
        return (IUserGetter)AppUtil.getBean(IUserGetter.class);
    }
}

