/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.api;

import com.hotent.open.app.api.ClientOption;
import com.hotent.open.app.api.OpenUcAppException;
import com.hotent.open.app.api.OpenUcClient;
import com.hotent.open.app.api.UcAppError;
import com.hotent.open.app.api.command.CommandDispatcher;
import com.hotent.open.app.api.open.OpenApiClient;
import com.hotent.open.app.api.open.OpenApiClientBuilder;
import com.hotent.open.app.api.protocol.AppServiceListener;
import com.hotent.open.app.api.security.UcCredential;
import com.hotent.open.app.stream.network.api.EndPointConnection;
import com.hotent.open.app.stream.network.core.EndPointConnectionFactory;
import com.hotent.open.app.stream.network.core.NetWorkService;
import com.hotent.open.app.stream.network.core.Subscription;
import java.net.Proxy;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;

class OpenUcStreamClient
implements OpenUcClient {
    private final UcCredential credential;
    private final CommandDispatcher dispatcher;
    private final ExecutorService executor;
    private final ClientOption option;
    private NetWorkService netWorkService;
    private OpenApiClient openApiClient;
    private Set<Subscription> subscriptions;
    private final AtomicReference<Status> status;
    private final Proxy proxy;

    public OpenUcStreamClient(UcCredential credential, CommandDispatcher dispatcher, ExecutorService executor, ClientOption option, Set<Subscription> subscriptions, Proxy proxy) {
        this.credential = credential;
        this.dispatcher = dispatcher;
        this.executor = executor;
        this.option = option;
        this.subscriptions = Collections.unmodifiableSet(subscriptions);
        this.status = new AtomicReference<Status>(Status.INIT);
        this.proxy = proxy;
    }

    @Override
    public synchronized void start() throws OpenUcAppException {
        if (this.status.get() == Status.INIT) {
            this.openApiClient = OpenApiClientBuilder.create().setHost(this.option.getOpenApiHost()).setTimeout(this.option.getConnectionTTL()).setProxy(this.proxy).build();
            EndPointConnectionFactory factory = () -> this.openConnection(this.credential, this.subscriptions, this.proxy);
            AppServiceListener listener = new AppServiceListener(this.dispatcher, this.executor);
            this.netWorkService = new NetWorkService(factory, listener, this.option.getMaxConnectionCount(), this.option.getConnectionTTL(), this.option.getConnectTimeout(), this.option.getKeepAliveOption().getKeepAliveIdleMill());
            this.netWorkService.start();
            this.status.set(Status.ACTIVE);
        } else if (this.status.get() == Status.INACTIVE) {
            throw new OpenUcAppException(UcAppError.CLIENT_STATE_ERROR, new String[0]);
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.status.get() == Status.ACTIVE) {
            if (this.netWorkService != null) {
                this.netWorkService.shutdown();
            }
            if (this.executor != null) {
                this.executor.shutdown();
            }
            this.status.set(Status.INACTIVE);
        }
    }

    @Override
    public NetWorkService getNetWorkService() {
        return this.netWorkService;
    }

    private EndPointConnection openConnection(UcCredential credential, Set<Subscription> subscriptions, Proxy proxy) throws Exception {
        return new EndPointConnection(credential.getClientId(), String.format("%s/%s/%s/%s", credential.getWsServerEndpointBaseUri(), credential.getClientId(), credential.getClientSecret(), credential.getTenantCode()), UUID.randomUUID().toString(), proxy);
    }

    static enum Status {
        INIT,
        ACTIVE,
        INACTIVE;

    }
}

