/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.api.callback;

import com.hotent.open.app.api.OpenUcAppException;
import com.hotent.open.app.api.UcAppError;
import com.hotent.open.app.api.callback.CallbackDescriptor;
import com.hotent.open.app.api.callback.OpenUcCallbackListener;
import com.hotent.open.app.api.protocol.CommandExecutor;
import com.hotent.open.app.api.protocol.MessageConverter;
import com.hotent.open.app.api.protocol.MessageConverterMapping;
import com.hotent.open.app.stream.network.api.Context;
import com.hotent.open.app.stream.network.api.logger.InternalLogger;
import com.hotent.open.app.stream.network.api.logger.InternalLoggerFactory;
import com.hotent.open.app.stream.protocol.ContentType;
import com.hotent.open.app.stream.protocol.callback.CallbackResponsePayload;
import java.util.HashMap;
import java.util.Map;

public class CallbackCommandExecutor
implements CommandExecutor {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(CallbackCommandExecutor.class);
    public final Map<String, CallbackDescriptor> callbackDescriptors = new HashMap<String, CallbackDescriptor>();

    public void register(String service, OpenUcCallbackListener<?, ?> callback) {
        this.callbackDescriptors.put(service, CallbackDescriptor.build(callback));
    }

    @Override
    public void execute(Context context) {
        CallbackResponsePayload payload;
        CallbackDescriptor descriptor = this.callbackDescriptors.get(context.getRequest().getTopic());
        if (descriptor == null) {
            context.exception(new OpenUcAppException(UcAppError.TOPIC_NOT_EXIST, new String[0]));
            return;
        }
        MessageConverter converter = MessageConverterMapping.getConverter(ContentType.of(context.getRequest().getContentType()));
        if (converter == null) {
            context.exception(UcAppError.UNKNOWN_CONTENT_TYPE.toException(new String[0]));
            return;
        }
        Object parameter = converter.convert(context.getRequest().getData(), descriptor.getParameterType());
        try {
            payload = descriptor.getMethod().execute(parameter);
        }
        catch (Exception e) {
            LOGGER.error("[UC] execute callback failed, topic={}", context.getRequest().getTopic(), e);
            context.exception(e);
            return;
        }
        context.replay(payload);
    }
}

