/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.api.callback;

import com.hotent.open.app.api.OpenUcAppException;
import com.hotent.open.app.api.UcAppError;
import com.hotent.open.app.api.callback.CallbackMethod;
import com.hotent.open.app.api.callback.OpenUcCallbackListener;
import com.hotent.open.app.api.callback.SimpleMethod;
import com.hotent.open.app.api.common.AopUtils;
import com.hotent.open.app.api.common.LambdaUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

class CallbackDescriptor {
    private final CallbackMethod method;
    private final Type parameterType;

    private CallbackDescriptor(CallbackMethod callbackMethod, Type parameterType) {
        this.method = callbackMethod;
        this.parameterType = parameterType;
    }

    public static <Req, Resp> CallbackDescriptor build(OpenUcCallbackListener<Req, Resp> callback) {
        Type target = null;
        if (LambdaUtils.isLambda(callback)) {
            List<Type> types = LambdaUtils.getLambdaParameterTypes(callback);
            if (types == null || types.size() != 1) {
                throw new OpenUcAppException(UcAppError.LAMBDA_PARSE_FAILED, new String[0]);
            }
            target = types.get(0);
        } else {
            Type[] types;
            for (Type type : types = AopUtils.getTargetClass(callback).getGenericInterfaces()) {
                Class rawType;
                if (!(type instanceof ParameterizedType) || !OpenUcCallbackListener.class.isAssignableFrom(rawType = (Class)((ParameterizedType)type).getRawType())) continue;
                target = ((ParameterizedType)type).getActualTypeArguments()[0];
                break;
            }
        }
        if (target == null) {
            throw new OpenUcAppException(UcAppError.ILLEGAL_CALLBACK, new String[0]);
        }
        return new CallbackDescriptor(new SimpleMethod(callback), target);
    }

    public Type getParameterType() {
        return this.parameterType;
    }

    public CallbackMethod getMethod() {
        return this.method;
    }
}

