/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.api.chatbot;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.hotent.open.app.api.util.IoUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class BotReplier {
    private final String webhook;
    private final int timeout = 60000;

    public BotReplier(String webhook) {
        this.webhook = webhook;
    }

    public static BotReplier fromWebhook(String webhook) {
        return new BotReplier(webhook);
    }

    public String replyText(String text) throws IOException {
        return this.replyText(text, null);
    }

    public String replyMarkdown(String title, String text) throws IOException {
        return this.replyMarkdown(title, text, null);
    }

    public String replyText(String text, List<String> atUserIds) throws IOException {
        byte[] bytes;
        HttpURLConnection connection = this.getHttpURLConnection();
        HashMap<String, String> textContent = new HashMap<String, String>();
        textContent.put("content", text);
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("msgtype", "text");
        request.put("text", textContent);
        if (atUserIds != null && !atUserIds.isEmpty()) {
            HashMap<String, List<String>> atContent = new HashMap<String, List<String>>();
            atContent.put("atUserIds", Collections.singletonList(""));
            request.put("at", atContent);
        }
        connection.getOutputStream().write(JSON.toJSONBytes(request, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteEnumUsingToString}));
        connection.getOutputStream().flush();
        if (connection.getResponseCode() == 200) {
            try {
                bytes = IoUtils.readAll(connection.getInputStream());
                return new String(bytes, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        try {
            bytes = IoUtils.readAll(connection.getErrorStream());
            throw new IOException(String.format("status=%s, msg=%s", connection.getResponseCode(), bytes != null ? new String(bytes) : ""));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public String replyMarkdown(String title, String text, List<String> atUserIds) throws IOException {
        byte[] bytes;
        HttpURLConnection connection = this.getHttpURLConnection();
        HashMap<String, String> markdownContent = new HashMap<String, String>();
        markdownContent.put("title", title);
        markdownContent.put("text", text);
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("msgtype", "markdown");
        request.put("markdown", markdownContent);
        if (atUserIds != null && !atUserIds.isEmpty()) {
            HashMap<String, List<String>> atContent = new HashMap<String, List<String>>();
            atContent.put("atUserIds", Collections.singletonList(""));
            request.put("at", atContent);
        }
        connection.getOutputStream().write(JSON.toJSONBytes(request, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteEnumUsingToString}));
        connection.getOutputStream().flush();
        if (connection.getResponseCode() == 200) {
            try {
                bytes = IoUtils.readAll(connection.getInputStream());
                return new String(bytes, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        try {
            bytes = IoUtils.readAll(connection.getErrorStream());
            throw new IOException(String.format("status=%s, msg=%s", connection.getResponseCode(), bytes != null ? new String(bytes) : ""));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private HttpURLConnection getHttpURLConnection() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.webhook).openConnection();
        connection.setRequestMethod("POST");
        connection.setReadTimeout(this.timeout);
        connection.setConnectTimeout(this.timeout);
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.connect();
        return connection;
    }
}

