/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.api.protocol;

import com.hotent.open.app.api.Preconditions;
import com.hotent.open.app.api.command.CommandDispatcher;
import com.hotent.open.app.stream.network.api.ClientConnectionListener;
import com.hotent.open.app.stream.network.api.Context;
import com.hotent.open.app.stream.network.api.logger.InternalLogger;
import com.hotent.open.app.stream.network.api.logger.InternalLoggerFactory;
import java.util.concurrent.Executor;

public class AppServiceListener
implements ClientConnectionListener {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(AppServiceListener.class);
    private final CommandDispatcher commandDispatcher;
    private final Executor executor;

    public AppServiceListener(CommandDispatcher commandDispatcher, Executor executor) {
        this.commandDispatcher = Preconditions.notNull(commandDispatcher);
        this.executor = Preconditions.notNull(executor);
    }

    @Override
    public void receive(Context context) {
        this.executor.execute(() -> {
            try {
                this.commandDispatcher.execute(context);
            }
            catch (Exception e) {
                LOGGER.error("[UC] dispatch command failed, {}", e, new Object[0]);
            }
        });
    }
}

