/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.api.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;

public class IpUtils {
    private static volatile String LOCAL = null;

    public static String getLocalIP() {
        return LOCAL;
    }

    private static InetAddress getIPv4() throws SocketException, UnknownHostException {
        ArrayList<InetAddress> v4Interfaces = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface interfaces = enumeration.nextElement();
            Enumeration<InetAddress> addresses = interfaces.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isLoopbackAddress() || address instanceof Inet6Address) continue;
                v4Interfaces.add(address);
            }
        }
        int v4InterfacesSize = v4Interfaces.size();
        if (v4InterfacesSize == 0) {
            return null;
        }
        for (InetAddress address : v4Interfaces) {
            String host = address.getHostAddress();
            if (host == null || host.startsWith("127.0") || host.startsWith("192.168")) continue;
            return address;
        }
        return (InetAddress)v4Interfaces.get(v4InterfacesSize - 1);
    }

    static {
        try {
            InetAddress address = IpUtils.getIPv4();
            if (address != null) {
                LOCAL = address.getHostAddress();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

