/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.stream.network.api;

import java.time.Duration;

public class ConnectOption {
    private long timeout;
    private long ttl;
    private Duration keepAliveIdle;
    private Duration keepAliveTimeout;

    private ConnectOption(long timeout, long ttl, Duration keepAliveIdle, Duration keepAliveTimeout) {
        this.timeout = timeout;
        this.ttl = ttl;
        this.keepAliveIdle = keepAliveIdle;
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getTtl() {
        return this.ttl;
    }

    public Duration getKeepAliveIdle() {
        return this.keepAliveIdle;
    }

    public Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public static class Builder {
        private long timeout;
        private long ttl;
        private Duration keepAliveIdle;
        private Duration keepAliveTimeout;

        public Builder setTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setTtl(long ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder setKeepAliveIdle(Duration keepAliveIdle) {
            this.keepAliveIdle = keepAliveIdle;
            return this;
        }

        public Builder setKeepAliveTimeout(Duration timeout) {
            this.keepAliveTimeout = timeout;
            return this;
        }

        public ConnectOption build() {
            return new ConnectOption(this.timeout, this.ttl, this.keepAliveIdle, this.keepAliveTimeout);
        }
    }
}

