/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.stream.network.core;

import com.hotent.open.app.stream.network.api.ClientConnectionListener;
import com.hotent.open.app.stream.network.api.ConnectOption;
import com.hotent.open.app.stream.network.api.EndPointConnection;
import com.hotent.open.app.stream.network.api.Protocol;
import com.hotent.open.app.stream.network.api.Session;
import com.hotent.open.app.stream.network.api.TransportConnector;
import com.hotent.open.app.stream.network.api.TransportProtocol;
import com.hotent.open.app.stream.network.api.exception.NetWorkError;
import com.hotent.open.app.stream.network.api.exception.UcNetworkException;
import com.hotent.open.app.stream.network.api.logger.InternalLogger;
import com.hotent.open.app.stream.network.api.logger.InternalLoggerFactory;
import com.hotent.open.app.stream.network.ws.WebsocketTransportConnector;
import java.time.Duration;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Connector {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(Connector.class);
    private static final Duration KEEP_ALIVE_TIMEOUT = Duration.ofMillis(5000L);
    private static final Map<TransportProtocol, TransportConnector> CONNECTOR_REGISTRY = new ConcurrentHashMap<TransportProtocol, TransportConnector>();
    private static final Lock INIT_LOCK = new ReentrantLock();
    private static volatile Boolean INIT = false;

    public static Session connect(EndPointConnection connection, ClientConnectionListener listener, long timeout, long ttl, long keepAliveIdle) throws Exception {
        Connector.ensureActive();
        TransportConnector connector = CONNECTOR_REGISTRY.get((Object)connection.getProtocol());
        if (connector == null) {
            throw new UcNetworkException(NetWorkError.PROTOCOL_ILLEGAL);
        }
        ConnectOption option = ConnectOption.builder().setTimeout(timeout).setTtl(ttl).setKeepAliveIdle(Duration.ofMillis(keepAliveIdle)).setKeepAliveTimeout(KEEP_ALIVE_TIMEOUT).build();
        return connector.connect(connection, listener, option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureActive() {
        if (INIT.booleanValue()) {
            return;
        }
        INIT_LOCK.lock();
        try {
            TransportProtocol[] supportedProtocols;
            Protocol protocols;
            TransportConnector transportConnector2;
            if (INIT.booleanValue()) {
                return;
            }
            ServiceLoader<TransportConnector> transportConnectors = ServiceLoader.load(TransportConnector.class);
            for (TransportConnector transportConnector2 : transportConnectors) {
                protocols = transportConnector2.getClass().getAnnotation(Protocol.class);
                if (protocols == null) continue;
                for (TransportProtocol supportedProtocol : supportedProtocols = protocols.protocol()) {
                    CONNECTOR_REGISTRY.put(supportedProtocol, transportConnector2);
                }
            }
            if (CONNECTOR_REGISTRY.isEmpty() && (protocols = (transportConnector2 = new WebsocketTransportConnector()).getClass().getAnnotation(Protocol.class)) != null) {
                for (TransportProtocol supportedProtocol : supportedProtocols = protocols.protocol()) {
                    CONNECTOR_REGISTRY.put(supportedProtocol, transportConnector2);
                }
            }
            INIT = true;
        }
        catch (Exception e) {
            LOGGER.error("[UC] client init transport failed, {}", e, new Object[0]);
        }
        finally {
            INIT_LOCK.unlock();
        }
    }
}

