/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.stream.network.ws;

import com.hotent.open.app.stream.network.api.logger.InternalLogger;
import com.hotent.open.app.stream.network.api.logger.InternalLoggerFactory;
import com.hotent.open.app.stream.network.api.utils.NettyByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class KeepAliveHandler
extends SimpleChannelInboundHandler<PongWebSocketFrame> {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(KeepAliveHandler.class);
    private final Duration timeout;
    private static final HashedWheelTimer TIMER = new HashedWheelTimer();
    private Channel channel;
    private final Map<String, Timeout> timeouts;
    private final AtomicBoolean active;

    public KeepAliveHandler(Duration timeout) {
        this.timeout = timeout;
        this.active = new AtomicBoolean(false);
        this.timeouts = new ConcurrentHashMap<String, Timeout>();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE && this.active.compareAndSet(false, true)) {
            this.channel = ctx.channel();
        }
        if (evt instanceof IdleStateEvent) {
            this.channel.eventLoop().execute((Runnable)new PingTask());
        }
        super.userEventTriggered(ctx, evt);
    }

    protected void channelRead0(ChannelHandlerContext ctx, PongWebSocketFrame msg) throws Exception {
        byte[] data = NettyByteBufUtils.getBytes(msg.content());
        Timeout out = this.timeouts.remove(new String(data));
        if (out != null) {
            out.cancel();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.shutdown();
        super.channelInactive(ctx);
    }

    private void shutdown() {
        Iterator<Map.Entry<String, Timeout>> it = this.timeouts.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Timeout> entry = it.next();
            entry.getValue().cancel();
            it.remove();
        }
    }

    private class PingTask
    implements Runnable {
        private PingTask() {
        }

        @Override
        public void run() {
            if (!KeepAliveHandler.this.timeouts.isEmpty()) {
                return;
            }
            String seq = UUID.randomUUID().toString();
            ByteBuf byteBuf = Unpooled.copiedBuffer((byte[])seq.getBytes());
            PingWebSocketFrame frame = new PingWebSocketFrame(byteBuf);
            KeepAliveHandler.this.channel.writeAndFlush((Object)frame).addListener(future -> {
                if (future.isSuccess()) {
                    Timeout pingTimeout = TIMER.newTimeout(timeout -> {
                        LOGGER.warn("[UC] connection ping timeout, channel is closing", new Object[0]);
                        KeepAliveHandler.this.timeouts.remove(seq);
                        KeepAliveHandler.this.channel.close();
                    }, KeepAliveHandler.this.timeout.toMillis(), TimeUnit.MILLISECONDS);
                    KeepAliveHandler.this.timeouts.put(seq, pingTimeout);
                } else {
                    KeepAliveHandler.this.channel.close();
                }
            });
        }
    }
}

