/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.stream.network.ws;

import com.alibaba.fastjson2.JSON;
import com.hotent.open.app.stream.network.api.utils.NettyByteBufUtils;
import com.hotent.open.app.stream.protocol.ProtocolRequest;
import com.hotent.open.app.stream.protocol.ProtocolResponse;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.ReferenceCountUtil;

public class ProtocolFrameHandler
extends ChannelDuplexHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof TextWebSocketFrame) {
            try {
                byte[] data = NettyByteBufUtils.getBytes(((TextWebSocketFrame)msg).content());
                ProtocolRequest request = (ProtocolRequest)JSON.parseObject((byte[])data, ProtocolRequest.class);
                ctx.fireChannelRead((Object)request);
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)msg);
            }
            return;
        }
        if (msg instanceof PingWebSocketFrame) {
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(((PingWebSocketFrame)msg).content()));
            return;
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ProtocolResponse) {
            TextWebSocketFrame frame = new TextWebSocketFrame(JSON.toJSONString((Object)msg));
            ctx.write((Object)frame);
        } else {
            super.write(ctx, msg, promise);
        }
    }
}

