/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.stream.network.ws;

import com.hotent.open.app.stream.network.api.ClientConnectionListener;
import com.hotent.open.app.stream.network.api.ConnectOption;
import com.hotent.open.app.stream.network.api.EndPointConnection;
import com.hotent.open.app.stream.network.api.NetworkSharedResources;
import com.hotent.open.app.stream.network.api.Protocol;
import com.hotent.open.app.stream.network.api.Session;
import com.hotent.open.app.stream.network.api.TransportConnector;
import com.hotent.open.app.stream.network.api.TransportProtocol;
import com.hotent.open.app.stream.network.api.logger.InternalLogger;
import com.hotent.open.app.stream.network.api.logger.InternalLoggerFactory;
import com.hotent.open.app.stream.network.ws.KeepAliveHandler;
import com.hotent.open.app.stream.network.ws.NettyClientHandler;
import com.hotent.open.app.stream.network.ws.ProtocolConnectHandler;
import com.hotent.open.app.stream.network.ws.ProtocolFrameHandler;
import com.hotent.open.app.stream.network.ws.WebSocketSession;
import com.hotent.open.app.stream.network.ws.WebsocketIdleHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

@Protocol(protocol={TransportProtocol.WS})
public class WebsocketTransportConnector
implements TransportConnector {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(WebsocketTransportConnector.class);

    @Override
    public Session connect(final EndPointConnection connection, final ClientConnectionListener listener, final ConnectOption option) throws Exception {
        LOGGER.info("[UC] start websocket connection, uri={}", connection.getEndPoint().toString());
        final CompletableFuture future = new CompletableFuture();
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.group(NetworkSharedResources.getNetWorkEventLoopGroup());
        ((Bootstrap)bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) throws Exception {
                if (connection.getProxy() != null) {
                    socketChannel.pipeline().addLast(new ChannelHandler[]{new HttpProxyHandler(connection.getProxy().address())});
                }
                WebSocketClientProtocolConfig config = WebSocketClientProtocolConfig.newBuilder().maxFramePayloadLength(262144).dropPongFrames(false).webSocketUri(WebsocketTransportConnector.configureWebsocketUri(connection)).handshakeTimeoutMillis(option.getTtl()).dropPongFrames(false).handleCloseFrames(true).build();
                SslContext sslContext = SslContextBuilder.forClient().build();
                if (connection.getProtocol().isTls()) {
                    // empty if block
                }
                socketChannel.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec()});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new WebSocketClientProtocolHandler(config)});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new WebsocketIdleHandler(option.getKeepAliveIdle())});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new ProtocolConnectHandler(future, option.getTimeout())});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new KeepAliveHandler(option.getKeepAliveTimeout())});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new ProtocolFrameHandler()});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new NettyClientHandler(connection.getConnectionId(), listener)});
            }
        })).connect(connection.getEndPoint().getHost(), connection.getEndPoint().getPort());
        future.get(option.getTimeout(), TimeUnit.MILLISECONDS);
        return new WebSocketSession((Channel)future.get(), connection.getConnectionId(), option.getTtl());
    }

    private static URI configureWebsocketUri(EndPointConnection connection) throws Exception {
        return connection.getEndPoint();
    }
}

