/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.stream.protocol;

import com.hotent.open.app.stream.protocol.ContentType;
import com.hotent.open.app.stream.protocol.ProtocolRequestFacade;
import java.util.HashMap;
import java.util.Map;

public class ProtocolResponse {
    private int code;
    private String message;
    private Map<String, String> headers;
    private String data;

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setHeader(String headerName, String headerValue) {
        if (headerName == null || headerValue == null) {
            return;
        }
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(headerName, headerValue);
    }

    public static ProtocolResponse new200Response(ProtocolRequestFacade request) {
        ProtocolResponse response = ProtocolResponse.base(request);
        response.setCode(200);
        response.setMessage("OK");
        response.setHeader("messageId", request.getMessageId());
        response.setHeader("contentType", request.getContentType());
        response.setHeader("time", String.valueOf(System.currentTimeMillis()));
        return response;
    }

    public static ProtocolResponse new500Response(ProtocolRequestFacade request) {
        ProtocolResponse response = ProtocolResponse.base(request);
        response.setCode(500);
        response.setMessage("client internal error");
        return response;
    }

    public static ProtocolResponse newErrorResponse(ProtocolRequestFacade request, int code, String msg) {
        ProtocolResponse response = ProtocolResponse.base(request);
        response.setCode(code);
        response.setMessage(msg);
        return response;
    }

    private static ProtocolResponse base(ProtocolRequestFacade request) {
        ProtocolResponse response = new ProtocolResponse();
        response.setHeader("messageId", request.getMessageId());
        response.setHeader("contentType", ContentType.APPLICATION_JSON.getContentType());
        return response;
    }
}

