/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.api;

import com.hotent.open.app.api.ClientOption;
import com.hotent.open.app.api.GenericEventListener;
import com.hotent.open.app.api.KeepAliveOption;
import com.hotent.open.app.api.OpenUcAppException;
import com.hotent.open.app.api.OpenUcClient;
import com.hotent.open.app.api.OpenUcStreamClient;
import com.hotent.open.app.api.Preconditions;
import com.hotent.open.app.api.UcAppError;
import com.hotent.open.app.api.callback.CallbackCommandExecutor;
import com.hotent.open.app.api.callback.OpenUcCallbackListener;
import com.hotent.open.app.api.command.CommandDispatcher;
import com.hotent.open.app.api.graph.GraphDispatcher;
import com.hotent.open.app.api.protocol.CommandExecutor;
import com.hotent.open.app.api.protocol.EventCommandExecutor;
import com.hotent.open.app.api.security.UcCredential;
import com.hotent.open.app.api.util.ThreadUtil;
import com.hotent.open.app.stream.network.api.NetProxy;
import com.hotent.open.app.stream.network.core.Subscription;
import com.hotent.open.app.stream.protocol.CommandType;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class OpenUcStreamClientBuilder {
    private int consumeThreads = 16;
    private final Map<CommandType, CommandExecutor> commands = new HashMap<CommandType, CommandExecutor>();
    private final Set<Subscription> subscriptions = new HashSet<Subscription>();
    private UcCredential credential;
    private int maxConnectionCount = 1;
    private int connectionTimeToLive = 21600000;
    private long connectTimeout = 3000L;
    private Proxy proxy;
    private KeepAliveOption keepAliveOption = new KeepAliveOption();
    private String openApiHost = "https://api.uc.com";

    private OpenUcStreamClientBuilder() {
    }

    public static OpenUcStreamClientBuilder custom() {
        return new OpenUcStreamClientBuilder();
    }

    public OpenUcStreamClientBuilder consumeThreads(int threads) {
        this.consumeThreads = Preconditions.checkPositive(threads);
        return this;
    }

    public OpenUcStreamClientBuilder registerAllEventListener(GenericEventListener listener) {
        Preconditions.notNull(listener);
        this.commands.put(CommandType.EVENT, new EventCommandExecutor(Preconditions.notNull(listener)));
        this.subscribe(CommandType.EVENT, "*");
        return this;
    }

    public OpenUcStreamClientBuilder keepAlive(KeepAliveOption keepAliveOption) {
        this.keepAliveOption = Preconditions.notNull(keepAliveOption);
        return this;
    }

    public <Req, Resp> OpenUcStreamClientBuilder registerCallbackListener(String topic, OpenUcCallbackListener<Req, Resp> callbackListener) {
        Preconditions.notNull(topic);
        Preconditions.notNull(callbackListener);
        CallbackCommandExecutor executor = (CallbackCommandExecutor)this.commands.computeIfAbsent(CommandType.CALLBACK, key -> new CallbackCommandExecutor());
        executor.register(topic, callbackListener);
        this.subscribe(CommandType.CALLBACK, topic);
        return this;
    }

    public OpenUcStreamClientBuilder maxConnectionCounts(int maxConnectionCount) {
        this.maxConnectionCount = Preconditions.checkPositive(maxConnectionCount);
        return this;
    }

    public OpenUcStreamClientBuilder credential(UcCredential credential) {
        this.credential = Preconditions.notNull(credential);
        return this;
    }

    @Deprecated
    public OpenUcStreamClientBuilder timeout(int timeout) {
        this.connectTimeout = Preconditions.checkPositive(timeout);
        return this;
    }

    public OpenUcStreamClientBuilder connectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    private OpenUcStreamClientBuilder openApiHost(String host) {
        this.openApiHost = Preconditions.notNull(host);
        return this;
    }

    public OpenUcStreamClientBuilder preEnv() {
        return this.openApiHost("https://pre-api.uc.com");
    }

    public OpenUcStreamClientBuilder proxy(NetProxy netProxy) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(netProxy.getIp(), (int)netProxy.getPort()));
        return this;
    }

    public OpenUcStreamClientBuilder forwardGraphRequestToHTTP(int port) {
        return this.registerCallbackListener("/v1.0/graph/api/invoke", new GraphDispatcher(port));
    }

    public OpenUcClient build() {
        ClientOption option = new ClientOption();
        option.setConnectTimeout(this.connectTimeout);
        option.setMaxConnectionCount(this.maxConnectionCount);
        option.setConnectionTTL(this.connectionTimeToLive);
        option.setOpenApiHost(this.openApiHost);
        option.setKeepAliveOption(this.keepAliveOption);
        ExecutorService executor = ThreadUtil.newFixedExecutor(this.consumeThreads, "UC-Consumer");
        return new OpenUcStreamClient(this.credential, new CommandDispatcher(this.commands), executor, option, this.subscriptions, this.proxy);
    }

    private void subscribe(CommandType type, String topic) {
        if (!this.subscriptions.add(new Subscription(type, topic))) {
            throw new OpenUcAppException(UcAppError.DUPLICATE_TOPIC_ERROR, type.name(), topic);
        }
    }
}

