/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.api.common;

import com.hotent.open.app.api.OpenUcAppException;
import com.hotent.open.app.api.UcAppError;
import java.lang.reflect.Method;

public class AopUtils {
    private static final String SPRING_PROXY = "org.springframework.aop.SpringProxy";
    private static final String TARGET_CLASS_AWARE = "org.springframework.aop.TargetClassAware";
    private static final String DECORATING_PROXY = "org.springframework.core.DecoratingProxy";

    public static Class<?> getTargetClass(Object candidate) {
        Class<Object> result = null;
        if (AopUtils.instanceOf(candidate.getClass(), TARGET_CLASS_AWARE)) {
            result = (Class<Object>)AopUtils.invoke(candidate, TARGET_CLASS_AWARE, "getTargetClass", new Object[0]);
        }
        if (result == null) {
            result = AopUtils.isCglibProxy(candidate) ? candidate.getClass().getSuperclass() : (AopUtils.isDecoratingProxy(candidate) ? (Class<Object>)AopUtils.invoke(candidate, DECORATING_PROXY, "getDecoratedClass", new Object[0]) : candidate.getClass());
        }
        return result;
    }

    public static boolean isCglibProxy(Object object) {
        return AopUtils.instanceOf(object.getClass(), SPRING_PROXY) && object.getClass().getCanonicalName().contains("$$");
    }

    private static boolean isDecoratingProxy(Object candidate) {
        return AopUtils.instanceOf(candidate.getClass(), DECORATING_PROXY);
    }

    private static boolean instanceOf(Class clazz, String interfaceName) {
        Class<?>[] superInterfaces;
        for (Class<?> interfaceClass : superInterfaces = clazz.getInterfaces()) {
            if (!interfaceClass.getCanonicalName().equals(interfaceName)) continue;
            return true;
        }
        return false;
    }

    private static Object invoke(Object object, String clazzName, String methodName, Object ... args) {
        try {
            Class<?> klass = Class.forName(clazzName);
            Method method = klass.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method.invoke(object, args);
        }
        catch (Exception e) {
            throw new OpenUcAppException(UcAppError.REFLECTION_ERROR, new String[0]);
        }
    }
}

