/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.api.graph;

import com.hotent.open.app.api.callback.OpenUcCallbackListener;
import com.hotent.open.app.api.graph.GraphAPIMethod;
import com.hotent.open.app.api.graph.GraphAPIRequest;
import com.hotent.open.app.api.graph.GraphAPIResponse;
import com.hotent.open.app.api.graph.StatusLine;
import com.hotent.open.app.api.util.GraphUtils;
import com.hotent.open.app.api.util.IoUtils;
import com.hotent.open.app.stream.network.api.logger.InternalLogger;
import com.hotent.open.app.stream.network.api.logger.InternalLoggerFactory;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GraphDispatcher
implements OpenUcCallbackListener<GraphAPIRequest, GraphAPIResponse> {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(GraphDispatcher.class);
    private final int port;

    public GraphDispatcher(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphAPIResponse execute(GraphAPIRequest request) {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL("http://127.0.0.1:" + this.port + request.getRequestLine().getUri().toString()).openConnection();
            connection.setRequestMethod(request.getRequestLine().getMethod().name());
            if (request.getHeaders() != null) {
                for (Map.Entry entry : request.getHeaders().entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            connection.setDoOutput(true);
            if (request.getRequestLine().getMethod() == GraphAPIMethod.POST) {
                connection.setDoInput(true);
            }
            connection.connect();
            if (request.getRequestLine().getMethod() == GraphAPIMethod.POST) {
                if (request.getBody() != null) {
                    connection.getOutputStream().write(request.getBody().getBytes());
                }
                connection.getOutputStream().flush();
            }
            int code = connection.getResponseCode();
            String msg = connection.getResponseMessage();
            StatusLine statusLine = new StatusLine(code, msg);
            GraphAPIResponse response = new GraphAPIResponse();
            response.setStatusLine(statusLine);
            if (code < 400) {
                response.setBody(new String(IoUtils.readAll(connection.getInputStream())));
            } else {
                response.setBody(new String(IoUtils.readAll(connection.getErrorStream())));
            }
            Map<String, List<String>> headerFields = connection.getHeaderFields();
            HashMap<String, String> headers = new HashMap<String, String>(4);
            if (headerFields != null) {
                for (Map.Entry entry : headerFields.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
                    headers.put(((String)entry.getKey()).toLowerCase(), (String)((List)entry.getValue()).get(0));
                }
            }
            response.setHeaders(headers);
            GraphAPIResponse graphAPIResponse = response;
            return graphAPIResponse;
        }
        catch (Exception e) {
            LOGGER.error("[UC] failed to forward graph request", e, new Object[0]);
            GraphAPIResponse graphAPIResponse = GraphUtils.failed(new StatusLine(500, e.getMessage()));
            return graphAPIResponse;
        }
        finally {
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }
}

