/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.api.protocol;

import com.alibaba.fastjson2.JSONObject;
import com.hotent.open.app.api.GenericEventListener;
import com.hotent.open.app.api.Preconditions;
import com.hotent.open.app.api.UcAppError;
import com.hotent.open.app.api.message.GenericOpenUcEvent;
import com.hotent.open.app.api.protocol.CommandExecutor;
import com.hotent.open.app.api.protocol.MessageConverter;
import com.hotent.open.app.api.protocol.MessageConverterMapping;
import com.hotent.open.app.stream.network.api.Context;
import com.hotent.open.app.stream.network.api.logger.InternalLogger;
import com.hotent.open.app.stream.network.api.logger.InternalLoggerFactory;
import com.hotent.open.app.stream.protocol.ContentType;
import com.hotent.open.app.stream.protocol.event.AckPayload;
import com.hotent.open.app.stream.protocol.event.EventAckStatus;
import java.lang.reflect.Type;

public class EventCommandExecutor
implements CommandExecutor {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(EventCommandExecutor.class);
    private final GenericEventListener listener;

    public EventCommandExecutor(GenericEventListener listener) {
        this.listener = Preconditions.notNull(listener);
    }

    @Override
    public void execute(Context context) {
        EventAckStatus status;
        ContentType contentType = ContentType.of(context.getRequest().getContentType());
        if (contentType == null) {
            context.exception(UcAppError.UNKNOWN_CONTENT_TYPE.toException(new String[0]));
            return;
        }
        MessageConverter converter = MessageConverterMapping.getConverter(contentType);
        if (converter == null) {
            context.exception(UcAppError.UNKNOWN_CONTENT_TYPE.toException(new String[0]));
            return;
        }
        GenericOpenUcEvent message = new GenericOpenUcEvent();
        Object object = converter.convert(context.getRequest().getData(), (Type)((Object)JSONObject.class));
        if (!(object instanceof JSONObject)) {
            context.exception(UcAppError.BAD_REQUEST_TYPE.toException(new String[0]));
            return;
        }
        message.setData((JSONObject)object);
        message.setEventId(context.getRequest().getHeader("eventId"));
        if (context.getRequest().getHeader("eventBornTime") != null) {
            message.setEventBornTime(Long.valueOf(context.getRequest().getHeader("eventBornTime")));
        }
        message.setEventCorpId(context.getRequest().getHeader("eventCorpId"));
        message.setEventType(context.getRequest().getHeader("eventType"));
        message.setEventTenantId(context.getRequest().getHeader("eventTenantId"));
        message.setEventUnifiedAppId(context.getRequest().getHeader("eventUnifiedAppId"));
        message.setData((JSONObject)object);
        try {
            status = this.listener.onEvent(message);
        }
        catch (Exception e) {
            LOGGER.error("[UC] consume message failed, eventId={}", message.getEventId(), e);
            context.exception(e);
            return;
        }
        AckPayload ackPayload = new AckPayload();
        ackPayload.setStatus(status);
        ackPayload.setEventId(message.getEventId());
        ackPayload.setEventTenantId(message.getEventTenantId());
        context.replay(ackPayload);
    }
}

