/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.stream.network.api.utils;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.Arrays;

public class NettyByteBufUtils {
    public static byte[] getBytes(ByteBuf buf) {
        return NettyByteBufUtils.getBytes(buf, buf.readerIndex(), buf.readableBytes(), true);
    }

    public static byte[] getBytes(ByteBuf buf, int start, int length, boolean copy) {
        int capacity = buf.capacity();
        if (MathUtil.isOutOfBounds((int)start, (int)length, (int)capacity)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= buf.capacity(" + capacity + ")");
        }
        if (buf.hasArray()) {
            int baseOffset = buf.arrayOffset() + start;
            byte[] bytes = buf.array();
            if (copy || baseOffset != 0 || length != bytes.length) {
                return Arrays.copyOfRange(bytes, baseOffset, baseOffset + length);
            }
            return bytes;
        }
        byte[] bytes = PlatformDependent.allocateUninitializedArray((int)length);
        buf.getBytes(start, bytes);
        return bytes;
    }
}

