/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.stream.network.core;

import com.hotent.open.app.stream.network.core.BackoffPolicy;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class ExponentialBackoffPolicy
implements BackoffPolicy {
    private final Random random = new Random();
    private final long initial = TimeUnit.SECONDS.toMillis(10L);
    private final long max = TimeUnit.MINUTES.toMillis(1L);
    private final double multiplier = 1.6;
    private final double jitter = 0.2;
    private long next = this.initial;

    @Override
    public long next() {
        long current = this.next;
        this.next = Math.min((long)((double)current * 1.6), this.max);
        double low = -0.2 * (double)current;
        double high = 0.2 * (double)current;
        return (long)((double)current + this.random.nextDouble() * (high - low) + low);
    }
}

