/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.stream.network.ws;

import com.hotent.open.app.stream.network.api.ClientConnectionListener;
import com.hotent.open.app.stream.network.api.logger.InternalLogger;
import com.hotent.open.app.stream.network.api.logger.InternalLoggerFactory;
import com.hotent.open.app.stream.network.ws.ProtocolFrameHandler;
import com.hotent.open.app.stream.network.ws.WebSocketContext;
import com.hotent.open.app.stream.protocol.DefaultProtocolRequestFacade;
import com.hotent.open.app.stream.protocol.ProtocolRequest;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;

public class NettyClientHandler
extends SimpleChannelInboundHandler<ProtocolRequest> {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(ProtocolFrameHandler.class);
    private final ClientConnectionListener listener;
    private final String connectionId;

    public NettyClientHandler(String connectionId, ClientConnectionListener listener) {
        this.connectionId = connectionId;
        this.listener = listener;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ProtocolRequest request) throws Exception {
        this.listener.receive(new WebSocketContext(this.connectionId, new DefaultProtocolRequestFacade(request), ctx));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOGGER.info("[UC] connection is closed, connectionId={}", this.connectionId);
        this.listener.onDisConnection(this.connectionId);
        super.channelInactive(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE) {
            // empty if block
        }
        super.userEventTriggered(ctx, evt);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof WebSocketClientHandshakeException) {
            LOGGER.error("[UC] connection establish error, please check connectionId={}", this.connectionId, cause);
        } else {
            LOGGER.error("[UC] connection operation failed, connectionId={}", this.connectionId, cause);
        }
    }
}

