/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.open.app.stream.network.ws;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.hotent.open.app.stream.network.api.Context;
import com.hotent.open.app.stream.network.api.ServiceException;
import com.hotent.open.app.stream.network.api.logger.InternalLogger;
import com.hotent.open.app.stream.network.api.logger.InternalLoggerFactory;
import com.hotent.open.app.stream.protocol.ProtocolRequestFacade;
import com.hotent.open.app.stream.protocol.ProtocolResponse;
import io.netty.channel.ChannelHandlerContext;

public class WebSocketContext
implements Context {
    private static InternalLogger LOGGER = InternalLoggerFactory.getLogger(WebSocketContext.class);
    private final ChannelHandlerContext context;
    private final ProtocolRequestFacade request;
    private final String connectionId;

    public WebSocketContext(String connectionId, ProtocolRequestFacade request, ChannelHandlerContext context) {
        this.context = context;
        this.connectionId = connectionId;
        this.request = request;
    }

    @Override
    public void replay(Object payload) {
        ProtocolResponse response = ProtocolResponse.new200Response(this.request);
        response.setData(JSON.toJSONString((Object)payload, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
        this.context.writeAndFlush((Object)response).addListener(future -> {
            if (!future.isSuccess()) {
                LOGGER.error("[UC] websocket connection reply response failed, connectionId={}, messageId={}", this.connectionId, this.request.getMessageId(), future.cause());
                this.context.close();
            }
        });
    }

    @Override
    public void exception(Throwable t) {
        ProtocolResponse response = t instanceof ServiceException ? ProtocolResponse.newErrorResponse(this.request, ((ServiceException)t).getCode(), t.getMessage()) : ProtocolResponse.new500Response(this.request);
        this.context.writeAndFlush((Object)response).addListener(future -> {
            if (!future.isSuccess()) {
                LOGGER.error("[UC] websocket connection reply response failed, connectionId={}, messageId={}", this.connectionId, this.request.getMessageId(), future.cause());
                this.context.close();
            }
        });
    }

    @Override
    public String connectionId() {
        return this.connectionId;
    }

    @Override
    public ProtocolRequestFacade getRequest() {
        return this.request;
    }
}

