/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.runtime.controller.auth;

import com.hotent.base.core.common.response.CommonResult;
import com.hotent.base.core.enums.IResponseInfo;
import com.hotent.uc.core.auth.dto.LoginDTO;
import com.hotent.uc.core.auth.service.AuthService;
import com.hotent.uc.core.auth.service.CaptchaService;
import com.hotent.uc.core.auth.vo.LoginResponseEntity;
import com.hotent.uc.core.auth.vo.LoginVo;
import com.hotent.uc.core.common.enums.UcResponseInfoEnums;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpSession;
import jakarta.validation.Valid;
import java.util.Optional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Auth")
@RestController
@RequestMapping(value={"/auth/v1/"})
public class AuthController {
    @Resource
    private CaptchaService captchaService;
    @Resource
    private AuthService authService;

    @PostMapping(value={"/login"})
    @Operation(summary="login")
    public LoginResponseEntity login(@RequestBody @Valid LoginVo loginVo) {
        return this.authService.createAuthenticationToken(loginVo);
    }

    @PostMapping(value={"/logout"})
    @Operation(summary="logout")
    public CommonResult<String> logout(HttpSession httpSession) {
        httpSession.invalidate();
        return CommonResult.result((IResponseInfo)UcResponseInfoEnums.LOGOUT);
    }

    @GetMapping(value={"/genCaptcha"})
    @Operation(summary="\u83b7\u53d6\u9a8c\u8bc1\u7801")
    public LoginDTO genCaptcha(@RequestParam Optional<String> account) {
        return this.captchaService.genCaptchaIfMeetConditions(account.orElse(""));
    }

    @GetMapping(value={"/unLock"})
    @Operation(summary="\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8fc7\u591a\u89e3\u9501")
    public CommonResult<String> unLock(@RequestParam String account) {
        this.authService.resetFailedCount(account);
        return CommonResult.ok();
    }
}

