/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.runtime.controller.bus;

import com.hotent.base.core.common.response.CommonResult;
import com.hotent.base.core.domain.page.PageList;
import com.hotent.base.core.domain.query.QueryFilter;
import com.hotent.base.core.enums.global.ResponseInfoEnums;
import com.hotent.uc.core.annotation.LogOperateType;
import com.hotent.uc.core.bus.manager.BusSystemManager;
import com.hotent.uc.core.bus.mapstruct.BusSystemConvert;
import com.hotent.uc.core.bus.model.BusSystem;
import com.hotent.uc.core.bus.vo.BusSystemVO;
import com.hotent.uc.core.common.enums.OperateTypeEnums;
import com.hotent.uc.core.user.manager.UserManager;
import com.hotent.uc.core.user.mapstruct.UserConvert;
import com.hotent.uc.runtime.controller.common.UcBaseController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.io.Serializable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/busSystems/v1"})
@Tag(name="\u4e1a\u52a1\u7cfb\u7edf\u63a7\u5236\u5668")
public class BusSystemController
extends UcBaseController<BusSystemManager, BusSystem> {
    @Resource
    UserConvert userConvert;
    @Resource
    BusSystemConvert busSystemConvert;
    @Resource
    UserManager userManager;

    @Override
    @PostMapping(value={"save"})
    @Operation(summary="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    @LogOperateType(value=OperateTypeEnums.ADD)
    public ResponseInfoEnums create(@RequestBody BusSystem t) {
        return ((BusSystemManager)this.baseService).save((Object)t) ? ResponseInfoEnums.SUCCESS_OPTION : ResponseInfoEnums.FAIL_OPTION;
    }

    @Override
    @PutMapping(value={"save"})
    @Operation(summary="\u66f4\u65b0\u5b9e\u4f53")
    @LogOperateType(value=OperateTypeEnums.EDIT)
    public ResponseInfoEnums updateById(@RequestBody BusSystem t) {
        return ((BusSystemManager)this.baseService).save((Object)t) ? ResponseInfoEnums.SUCCESS_OPTION : ResponseInfoEnums.FAIL_OPTION;
    }

    @GetMapping(value={"/detail/{id}"})
    @Operation(summary="\u4e1a\u52a1\u7cfb\u7edf\u6570\u636e\u8be6\u60c5", description="\u4e1a\u52a1\u7cfb\u7edf\u6570\u636e\u8be6\u60c5")
    @Parameters(value={@Parameter(name="id", description="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true, in=ParameterIn.PATH)})
    public BusSystemVO detail(@PathVariable String id) throws Exception {
        return (BusSystemVO)((BusSystem)((BusSystemManager)this.baseService).get((Serializable)((Object)id))).copyProperties(BusSystemVO.class);
    }

    @PostMapping(value={"/pageList"}, produces={"application/json; charset=utf-8"})
    @Operation(summary="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BusSystemVO> pageList(@RequestBody QueryFilter<BusSystem> queryFilter) {
        return super.query(queryFilter).transRowsType(p -> this.busSystemConvert.toVO(p));
    }

    @GetMapping(value={"/getSecret/{code}"})
    @Operation(summary="\u6839\u636ecode\u751f\u6210Secret", description="\u6839\u636ecode\u751f\u6210Secret")
    @Parameters(value={@Parameter(name="code", description="code", required=true, in=ParameterIn.PATH)})
    public CommonResult<String> getSecretByCode(@PathVariable String code) throws Exception {
        return ((BusSystemManager)this.baseService).getSecretByCode(code);
    }

    @GetMapping(value={"authBusSystem"})
    @Operation(summary="\u5916\u90e8\u7cfb\u7edf\u8ba4\u8bc1", description="\u5916\u90e8\u7cfb\u7edf\u8ba4\u8bc1")
    @Parameters(value={@Parameter(name="appKey", description="appKey", required=true, in=ParameterIn.QUERY), @Parameter(name="appSecret", description="appSecret", required=true, in=ParameterIn.QUERY)})
    public BusSystemVO authBusSystem(@RequestParam String appKey, @RequestParam String appSecret) {
        return ((BusSystemManager)this.baseService).authBusSystem(appKey, appSecret);
    }
}

