/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.runtime.controller.common;

import com.hotent.base.core.context.IUserIdentity;
import com.hotent.base.core.context.UserIdentityTypeEnums;
import com.hotent.uc.core.feign.UcFeignService;
import com.hotent.uc.core.util.RSAUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/tools/v1/"})
@Tag(name="\u7528\u6237\u6a21\u5757\u5de5\u5177\u63a5\u53e3")
public class ToolsController {
    @Value(value="${spring.profiles.version:9.0}")
    String platformVersion;
    @Resource
    UcFeignService ucFeignService;

    @GetMapping(value={"/publicKey"})
    @Operation(summary="\u83b7\u53d6RSA\u52a0\u5bc6\u7684\u516c\u94a5", description="\u83b7\u53d6RSA\u52a0\u5bc6\u7684\u516c\u94a5")
    public String getPublicKey() throws Exception {
        return RSAUtil.publicKey;
    }

    @GetMapping(value={"/platformVersion"})
    @Operation(summary="\u83b7\u53d6\u5e73\u53f0\u7248\u672c", description="\u83b7\u53d6\u5e73\u53f0\u7248\u672c")
    public String getPlatformVersion() {
        return this.platformVersion;
    }

    @PostMapping(value={"/getByTypeAndCodes"})
    @Operation(summary="\u6839\u636e\u7c7b\u578b\u548c\u7f16\u7801list\u6279\u91cf\u83b7\u53d6\u5bf9\u8c61", description="\u6839\u636e\u7c7b\u578b\u548c\u7f16\u7801list\u6279\u91cf\u83b7\u53d6\u5bf9\u8c61")
    public List<IUserIdentity> getByTypeAndCodes(@RequestParam UserIdentityTypeEnums type, @RequestBody List<String> codes) {
        return this.ucFeignService.getByTypeAndCodes(type, codes);
    }
}

