/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.runtime.controller.common;

import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.core.common.exception.bean.BaseException;
import com.hotent.base.core.common.response.CommonResult;
import com.hotent.base.core.domain.page.PageList;
import com.hotent.base.core.domain.query.FieldSort;
import com.hotent.base.core.domain.query.QueryFilter;
import com.hotent.base.core.enums.entity.Direction;
import com.hotent.base.core.enums.global.ResponseInfoEnums;
import com.hotent.base.core.utils.HttpUtil;
import com.hotent.base.mybatisplus.mvc.manager.BaseManager;
import com.hotent.base.mybatisplus.mvc.manager.CommonManager;
import com.hotent.base.mybatisplus.mvc.model.AutoFillModel;
import com.hotent.uc.core.annotation.LogOperateType;
import com.hotent.uc.core.annotation.TableAlias;
import com.hotent.uc.core.common.enums.OperateTypeEnums;
import com.hotent.uc.core.util.EasyExcelUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public class UcBaseController<M extends BaseManager<T>, T extends Model<T>> {
    @Autowired
    protected M baseService;
    @Autowired
    CommonManager commonManager;

    @PostMapping
    @Operation(summary="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    @LogOperateType(value=OperateTypeEnums.ADD)
    public ResponseInfoEnums create(@RequestBody T t) {
        return this.baseService.save(t) ? ResponseInfoEnums.SUCCESS_OPTION : ResponseInfoEnums.FAIL_OPTION;
    }

    @PutMapping
    @Operation(summary="\u66f4\u65b0\u5b9e\u4f53")
    @LogOperateType(value=OperateTypeEnums.EDIT)
    public ResponseInfoEnums updateById(@RequestBody T t) {
        return this.baseService.updateById(t) ? ResponseInfoEnums.SUCCESS_OPTION : ResponseInfoEnums.FAIL_OPTION;
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="\u6839\u636eid\u5220\u9664")
    @LogOperateType(value=OperateTypeEnums.DEL)
    @Parameter(name="id", description="\u5b9e\u4f53id", in=ParameterIn.PATH)
    public ResponseInfoEnums deleteById(@PathVariable String id) {
        return this.baseService.removeById((Serializable)((Object)id)) ? ResponseInfoEnums.SUCCESS_OPTION : ResponseInfoEnums.FAIL_OPTION;
    }

    @DeleteMapping
    @Operation(summary="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    @LogOperateType(value=OperateTypeEnums.DEL)
    @Parameter(name="ids", description="\u5b9e\u4f53\u96c6\u5408", in=ParameterIn.QUERY)
    public ResponseInfoEnums deleteByIds(String ... ids) {
        return this.baseService.removeByIds(Arrays.asList(ids)) ? ResponseInfoEnums.SUCCESS_OPTION : ResponseInfoEnums.FAIL_OPTION;
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @Operation(summary="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<T> query(@RequestBody @Valid QueryFilter<T> queryFilter) {
        Class currentModelClass = this.baseService.getEntityClass();
        try {
            Model newInstance = (Model)currentModelClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (newInstance instanceof AutoFillModel && ObjUtil.isEmpty((Object)queryFilter.getSorter())) {
                queryFilter.withSorter(new FieldSort("created_time_", Direction.DESC));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.baseService.query(queryFilter);
    }

    @GetMapping(value={"/{id}"})
    @Operation(summary="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    @Parameter(name="id", description="id", in=ParameterIn.PATH)
    public T getById(@PathVariable String id) {
        return (T)((Model)this.baseService.getById((Serializable)((Object)id)));
    }

    @GetMapping(value={"/restoreByCode/{code}"})
    @Operation(summary="\u6839\u636e\u7f16\u7801\u6216\u8005\u522b\u540d\u6062\u590d\u88ab\u903b\u8f91\u5220\u9664\u7684\u6570\u636e", description="\u6839\u636e\u7f16\u7801\u6216\u8005\u522b\u540d\u6062\u590d\u88ab\u903b\u8f91\u5220\u9664\u7684\u6570\u636e")
    public CommonResult<String> restoreByAlias(@PathVariable String code) {
        Class currentModelClass = this.baseService.getEntityClass();
        return this.restoreByClassAndAlias(currentModelClass, code);
    }

    CommonResult<String> restoreByClassAndAlias(Class<?> currentModelClass, String code) {
        int execute;
        Field[] allField = ReflectUtil.getFields(currentModelClass);
        String aliasField = null;
        TableField logicField = null;
        String aliasDesc = "";
        for (Field f : allField) {
            TableAlias annotation = f.getAnnotation(TableAlias.class);
            if (annotation != null) {
                TableField aliasF = f.getAnnotation(TableField.class);
                if (aliasF != null) {
                    aliasField = aliasF.value();
                } else {
                    TableId tableId = f.getAnnotation(TableId.class);
                    aliasField = tableId.value();
                }
                aliasDesc = annotation.value();
            }
            if (f.getAnnotation(TableLogic.class) == null) continue;
            logicField = f.getAnnotation(TableField.class);
        }
        if (StrUtil.isEmpty((CharSequence)code)) {
            return CommonResult.error((String)String.format("%s\u4e0d\u80fd\u4e3a\u7a7a", aliasDesc));
        }
        if (aliasField == null) {
            return CommonResult.error((String)"\u6062\u590d\u5931\u8d25\uff1a\u5bf9\u8c61\u6ca1\u6709\u522b\u540d\u5b57\u6bb5\u5b57\u6bb5");
        }
        if (logicField == null) {
            return CommonResult.error((String)"\u6062\u590d\u5931\u8d25\uff1a\u5bf9\u8c61\u6ca1\u6709\u903b\u8f91\u5220\u9664\u5b57\u6bb5");
        }
        TableName tableName = currentModelClass.getAnnotation(TableName.class);
        if (tableName == null) {
            throw new BaseException("\u6062\u590d\u5931\u8d25\uff1a\u5bf9\u8c61\u6ca1\u6709\u8868\u540d\u6ce8\u89e3");
        }
        Object sql = String.format("update %s set  %s ='0'  where %s = '%s' ", tableName.value(), logicField.value(), aliasField, code);
        HttpServletRequest request = HttpUtil.getRequest();
        if (ObjUtil.isNotEmpty((Object)request) && StrUtil.isNotEmpty((CharSequence)request.getParameter("tenantId"))) {
            sql = (String)sql + String.format(" and tenant_id_='%s' ", request.getParameter("tenantId"));
        }
        if ((execute = this.commonManager.execute((String)sql)) > 0) {
            return CommonResult.ok().message("\u6062\u590d\u6210\u529f");
        }
        return CommonResult.error((String)String.format("\u6062\u590d\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5%s[%s]\u662f\u5426\u5b58\u5728\u8fc7", aliasDesc, code));
    }

    @PostMapping(value={"/export"})
    @Operation(summary="\u5bfc\u51fa\u6570\u636e", description="\u5bfc\u51fa\u6570\u636e")
    @Parameters(value={@Parameter(name="ids", description="\u5bf9\u8c61id\u5b57\u7b26\u4e32", required=true, in=ParameterIn.PATH)})
    public void export(HttpServletResponse response, @RequestBody List<String> ids) throws Exception {
        QueryWrapper wrapper = new QueryWrapper();
        TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)this.baseService.getEntityClass());
        wrapper.in((Object)tableInfo.getKeyColumn(), ids);
        List list = this.baseService.list((Wrapper)wrapper);
        EasyExcelUtil.downloadExcel((OutputStream)response.getOutputStream(), (String)"sheet1", (List)list);
    }
}

