/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.runtime.controller.feign;

import com.hotent.base.auth.model.userdetails.AuthUserDetailsImpl;
import com.hotent.base.auth.param.AuthResponseEntity;
import com.hotent.base.core.context.UserIdentityGroup;
import com.hotent.base.core.context.UserIdentityTypeEnums;
import com.hotent.base.core.context.impl.DefaultUserIdentity;
import com.hotent.base.core.domain.page.PageList;
import com.hotent.base.core.domain.query.QueryFilter;
import com.hotent.base.core.tenant.model.TenantSqlResource;
import com.hotent.base.ddl.util.SqlResourceUtil;
import com.hotent.uc.core.auth.dto.LoginDTO;
import com.hotent.uc.core.auth.service.AuthService;
import com.hotent.uc.core.feign.UcFeignService;
import com.hotent.uc.core.org.manager.OrgManager;
import com.hotent.uc.core.org.manager.OrgPostManager;
import com.hotent.uc.core.org.manager.impl.OrgJobManagerImpl;
import com.hotent.uc.core.org.model.Org;
import com.hotent.uc.core.org.model.OrgJob;
import com.hotent.uc.core.org.model.OrgPost;
import com.hotent.uc.core.role.manager.RoleManager;
import com.hotent.uc.core.role.model.Role;
import com.hotent.uc.core.user.manager.UserManager;
import com.hotent.uc.core.user.model.User;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/feign/v1"})
@Tag(name="\u7528\u6237\u4e2d\u5fc3feign\u63a5\u53e3\u63a7\u5236\u5668")
public class UcFeignController {
    @Resource
    UcFeignService ucFeignService;
    @Resource
    UserManager userManager;
    @Resource
    RoleManager roleManager;
    @Resource
    OrgManager orgManager;
    @Resource
    OrgPostManager orgPostManager;
    @Resource
    AuthService authService;
    @Resource
    UserDetailsService userDetailsService;
    @Autowired
    private OrgJobManagerImpl orgJobManager;

    @GetMapping(value={"/getByAccount/{account}"})
    @Operation(summary="\u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u7528\u6237\u5bf9\u8c61", description="\u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u7528\u6237\u5bf9\u8c61")
    @Parameters(value={@Parameter(name="account", description="\u7528\u6237\u8d26\u53f7", required=true, in=ParameterIn.PATH)})
    public User getByAccount(@PathVariable String account) throws Exception {
        return this.userManager.getByAccount(account);
    }

    @GetMapping(value={"/getById/{id}"})
    @Operation(summary="\u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u7528\u6237\u5bf9\u8c61", description="\u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u7528\u6237\u5bf9\u8c61")
    @Parameters(value={@Parameter(name="id", description="\u7528\u6237\u8d26\u53f7", required=true, in=ParameterIn.PATH)})
    public User getById(@PathVariable String id) throws Exception {
        return (User)this.userManager.get((Serializable)((Object)id));
    }

    @GetMapping(value={"/getCurrentIdentitys"})
    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u8eab\u4efd\u4fe1\u606f(\u7528\u6237\uff0c\u7ec4\u7ec7\uff0c\u89d2\u8272\uff0c\u5c97\u4f4d\uff0c\u804c\u52a1)", description="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u8eab\u4efd\u4fe1\u606f(\u7528\u6237\uff0c\u7ec4\u7ec7\uff0c\u89d2\u8272\uff0c\u5c97\u4f4d\uff0c\u804c\u52a1)")
    public List<UserIdentityGroup> getCurrentIdentitys() throws Exception {
        return this.ucFeignService.getCurrentIdentitys();
    }

    @GetMapping(value={"/getUserIdentityList"})
    @Operation(summary="\u83b7\u53d6\u7528\u6237\u7684\u8eab\u4efd\u4fe1\u606f", description="\u83b7\u53d6\u7528\u6237\u7684\u8eab\u4efd\u4fe1\u606f")
    public List<UserIdentityGroup> getUserIdentityList(@RequestParam String userId) throws Exception {
        return this.ucFeignService.getUserIdentityList(userId);
    }

    @GetMapping(value={"/getUserOrgs"})
    @Operation(summary="\u83b7\u53d6\u7528\u6237\u7684\u7ec4\u7ec7)", description="\u83b7\u53d6\u7528\u6237\u7684\u7ec4\u7ec7")
    public List<DefaultUserIdentity> getUserOrgs(@RequestParam String account) throws Exception {
        return this.ucFeignService.getUserOrgs(account);
    }

    @GetMapping(value={"/getUserMainOrg"})
    @Operation(summary="\u83b7\u53d6\u7528\u6237\u7684\u7ec4\u7ec7)", description="\u83b7\u53d6\u7528\u6237\u7684\u7ec4\u7ec7")
    public Org getUserMainOrg(@RequestParam String account, @RequestParam Optional<String> demId) throws Exception {
        return this.ucFeignService.getUserMainOrg(account, demId.orElse(""));
    }

    @GetMapping(value={"/getUserPosts"})
    @Operation(summary="\u83b7\u53d6\u7528\u6237\u7684\u5c97\u4f4d", description="\u83b7\u53d6\u7528\u6237\u7684\u5c97\u4f4d")
    public List<DefaultUserIdentity> getUserPosts(@RequestParam String account) throws Exception {
        return this.ucFeignService.getUserPosts(account);
    }

    @GetMapping(value={"/getUserRoles"})
    @Operation(summary="\u83b7\u53d6\u7528\u6237\u7684\u89d2\u8272", description="\u83b7\u53d6\u7528\u6237\u7684\u89d2\u8272")
    public List<DefaultUserIdentity> getUserRoles(@RequestParam String account) throws Exception {
        return this.ucFeignService.getUserRoles(account);
    }

    @GetMapping(value={"/getUserJobs"})
    @Operation(summary="\u83b7\u53d6\u7528\u6237\u7684\u804c\u52a1", description="\u83b7\u53d6\u7528\u6237\u7684\u804c\u52a1")
    public List<DefaultUserIdentity> getUserJobs(@RequestParam String account) throws Exception {
        return this.ucFeignService.getUserJobs(account);
    }

    @PostMapping(value={"/getIdentitysByCodes"})
    @Operation(summary="\u6839\u636e\u8eab\u4efd\u7c7b\u578b\u548c\u7f16\u7801list\u6279\u91cf\u83b7\u53d6\u8eab\u4efd\u5bf9\u8c61", description="\u6839\u636e\u8eab\u4efd\u7c7b\u578b\u548c\u7f16\u7801list\u6279\u91cf\u83b7\u53d6\u8eab\u4efd\u5bf9\u8c61")
    public List<DefaultUserIdentity> getIdentitysByCodes(@RequestParam UserIdentityTypeEnums type, @RequestBody List<String> codes) {
        return this.ucFeignService.getIdentitysByCodes(type, codes);
    }

    @PostMapping(value={"/extractIdentityByCodes"})
    @Operation(summary="\u6839\u636e\u8eab\u4efd\u7c7b\u578b\u548c\u7f16\u7801\uff0c\u83b7\u53d6\u5176\u4e2d\u7684\u7528\u6237", description="\u6839\u636e\u8eab\u4efd\u7c7b\u578b\u548c\u7f16\u7801\uff0c\u83b7\u53d6\u5176\u4e2d\u7684\u7528\u6237")
    public List<DefaultUserIdentity> extractIdentityByCodes(@RequestParam UserIdentityTypeEnums type, @RequestBody List<String> codes) {
        return this.ucFeignService.extractIdentityByCodes(type, codes);
    }

    @PostMapping(value={"/extractIdentityByIds"})
    @Operation(summary=" \u6839\u636e\u8eab\u4efd\u7c7b\u578b\u548cid\uff0c\u83b7\u53d6\u5176\u4e2d\u7684\u7528\u6237", description=" \u6839\u636e\u8eab\u4efd\u7c7b\u578b\u548cid\uff0c\u83b7\u53d6\u5176\u4e2d\u7684\u7528\u6237")
    public List<DefaultUserIdentity> extractIdentityByIds(@RequestParam UserIdentityTypeEnums type, @RequestBody List<String> ids) {
        return this.ucFeignService.extractIdentityByIds(type, ids);
    }

    @GetMapping(value={"/getUserBelongOrgMaster"})
    @Operation(summary="\u6839\u636e\u8eab\u4efd\u7c7b\u578b\u548c\u7f16\u7801\uff0c\u83b7\u53d6\u5176\u4e2d\u7684\u7528\u6237", description="\u6839\u636e\u8eab\u4efd\u7c7b\u578b\u548c\u7f16\u7801\uff0c\u83b7\u53d6\u5176\u4e2d\u7684\u7528\u6237")
    public List<DefaultUserIdentity> getUserBelongOrgMaster(@RequestParam String userId, @RequestParam String demId) {
        return this.ucFeignService.getUserBelongOrgMaster(userId, demId);
    }

    @GetMapping(value={"/getServiceInitSqlResource"})
    @Operation(summary="\u83b7\u53d6\u7528\u6237\u4e2d\u5fc3\u7684\u7ec4\u7ec7\u521d\u59cb\u5316sql\u4fe1\u606f", description="\u83b7\u53d6\u7528\u6237\u4e2d\u5fc3\u7684\u7ec4\u7ec7\u521d\u59cb\u5316sql\u4fe1\u606f")
    public TenantSqlResource getServiceInitSqlResource(@RequestParam String dbType) throws IOException {
        TenantSqlResource tenetSqlResource = SqlResourceUtil.getDdlDmlResources((String)dbType);
        tenetSqlResource.setServiceName("\u7528\u6237\u4e2d\u5fc3\u670d\u52a1");
        return tenetSqlResource;
    }

    @PostMapping(value={"/get/userList"})
    @Operation(summary="\u83b7\u53d6\u7528\u6237\u5206\u9875\u4fe1\u606f", description="\u83b7\u53d6\u7528\u6237\u5206\u9875\u4fe1\u606f")
    public PageList<User> getUserList(@RequestBody QueryFilter<User> queryFilter) throws Exception {
        return this.userManager.query(queryFilter);
    }

    @PostMapping(value={"/get/roleList"})
    @Operation(summary="\u83b7\u53d6\u89d2\u8272\u5206\u9875\u4fe1\u606f", description="\u83b7\u53d6\u89d2\u8272\u5206\u9875\u4fe1\u606f")
    public PageList<Role> getRoleList(@RequestBody QueryFilter<Role> queryFilter) throws Exception {
        return this.roleManager.query(queryFilter);
    }

    @PostMapping(value={"/get/orgList"})
    @Operation(summary="\u83b7\u53d6\u7ec4\u7ec7\u5206\u9875\u4fe1\u606f", description="\u83b7\u53d6\u7ec4\u7ec7\u5206\u9875\u4fe1\u606f")
    public PageList<Org> getOrgList(@RequestBody QueryFilter<Org> queryFilter) throws Exception {
        return this.orgManager.query(queryFilter);
    }

    @PostMapping(value={"/get/postList"})
    @Operation(summary="\u83b7\u53d6\u5c97\u4f4d\u5206\u9875\u4fe1\u606f", description="\u83b7\u53d6\u5c97\u4f4d\u5206\u9875\u4fe1\u606f")
    public PageList<OrgPost> getPostList(@RequestBody QueryFilter<OrgPost> queryFilter) throws Exception {
        return this.orgPostManager.query(queryFilter);
    }

    @PostMapping(value={"/get/jobList"})
    @Operation(summary="\u83b7\u53d6\u804c\u52a1\u5206\u9875\u4fe1\u606f", description="\u83b7\u53d6\u804c\u52a1\u5206\u9875\u4fe1\u606f")
    public PageList<OrgJob> getJobList(@RequestBody QueryFilter<OrgJob> queryFilter) throws Exception {
        return this.orgJobManager.query(queryFilter);
    }

    @PostMapping(value={"/user/createAuthenticationJwtToken"})
    @Operation(summary="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", description="\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public AuthResponseEntity createAuthenticationJwtToken(@RequestBody LoginDTO loginDTO) throws Exception {
        return this.authService.createAuthenticationJwtToken(loginDTO);
    }

    @GetMapping(value={"/loadUserByUsername/{account}"})
    @Operation(summary="\u83b7\u53d6\u7528\u6237\u5bf9\u8c61", description="\u83b7\u53d6\u7528\u6237\u5bf9\u8c61")
    @Parameters(value={@Parameter(name="account", description="\u7528\u6237\u8d26\u53f7", required=true, in=ParameterIn.PATH)})
    public AuthUserDetailsImpl loadUserByUsername(@PathVariable String account) throws IOException {
        return (AuthUserDetailsImpl)this.userDetailsService.loadUserByUsername(account);
    }

    @PostMapping(value={"/org/getChildOrgIds"})
    @Operation(summary="\u83b7\u53d6\u4e0b\u7ea7\u7ec4\u7ec7id", description="\u83b7\u53d6\u4e0b\u7ea7\u7ec4\u7ec7id")
    public Set<String> getChildOrgIds(@RequestBody List<String> orgIds) throws Exception {
        return this.orgManager.getChildOrgIds(orgIds);
    }
}

