/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.runtime.controller.menu;

import cn.hutool.core.util.StrUtil;
import com.hotent.base.core.common.response.CommonResult;
import com.hotent.base.core.utils.BeanUtil;
import com.hotent.base.mybatisplus.mvc.controller.BaseController;
import com.hotent.uc.core.menu.manager.SysMenuInterfaceManager;
import com.hotent.uc.core.menu.manager.SysMenuManager;
import com.hotent.uc.core.menu.mapstruct.SysMenuConvert;
import com.hotent.uc.core.menu.model.SysMenu;
import com.hotent.uc.core.menu.model.SysMenuInterface;
import com.hotent.uc.core.menu.vo.SysMenuRouterVO;
import com.hotent.uc.core.menu.vo.SysMenuVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.validation.Valid;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/sysMenus/v1"})
@Tag(name="\u7cfb\u7edf\u83dc\u5355\u63a7\u5236\u5668")
public class SysMenuController
extends BaseController<SysMenuManager, SysMenu> {
    @Resource
    SysMenuConvert sysMenuConvert;
    @Resource
    SysMenuInterfaceManager sysMenuInterfaceManager;

    @GetMapping(value={"/sysMenu/detailWithMethod/{alias}"})
    @Operation(summary="\u6839\u636e\u522b\u540d\u83b7\u53d6\u83dc\u5355\u8be6\u60c5(\u5305\u542b\u83dc\u5355\u4e0b\u7684\u65b9\u6cd5)", description="\u6839\u636e\u522b\u540d\u83b7\u53d6\u83dc\u5355\u8be6\u60c5(\u5305\u542b\u83dc\u5355\u4e0b\u7684\u65b9\u6cd5)")
    @Parameters(value={@Parameter(name="alias", description="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true, in=ParameterIn.PATH)})
    public SysMenuVO detail(@PathVariable String alias) throws Exception {
        return this.sysMenuConvert.toVO(((SysMenuManager)this.baseService).getByAliasWithMethod(alias));
    }

    @GetMapping(value={"/sysMenus/menuTree"})
    @Operation(summary="\u83b7\u53d6\u83dc\u5355\u6811", description="\u83b7\u53d6\u83dc\u5355\u6811")
    @Parameters(value={@Parameter(name="sysCode", description="\u7cfb\u7edf\u7f16\u7801", required=true, in=ParameterIn.QUERY), @Parameter(name="getInterface", description="\u662f\u5426\u83b7\u53d6\u83dc\u5355\u4e0b\u7684\u63a5\u53e3", required=true, in=ParameterIn.QUERY), @Parameter(name="ignoreAlias", description="\u5ffd\u7565\u67e5\u8be2\u7684\u83dc\u5355\u522b\u540d(\u4e0b\u7ea7\u4e5f\u4f1a\u4e00\u8d77\u5ffd\u7565)", required=true, in=ParameterIn.QUERY)})
    public List<SysMenuVO> getMenuTree(@RequestParam String sysCode, @RequestParam Optional<String> ignoreAlias, @RequestParam Optional<Boolean> getInterface) throws Exception {
        List allByTenant = ((SysMenuManager)this.baseService).getAllByTenant(sysCode, ignoreAlias.orElse(""));
        if (getInterface.orElse(false).booleanValue()) {
            Map<String, List<SysMenuInterface>> interfaceMap = this.sysMenuInterfaceManager.getBySysCode(sysCode).stream().collect(Collectors.groupingBy(SysMenuInterface::getMenuId));
            allByTenant.forEach(m -> m.setInterfaces((List)interfaceMap.get(m.getId())));
        }
        return BeanUtil.listToTree((List)this.sysMenuConvert.toVOs((Collection)allByTenant));
    }

    @PostMapping(value={"/sysMenu/save"})
    @Operation(summary="\u4fdd\u5b58\u83dc\u5355", description="\u4fdd\u5b58\u83dc\u5355")
    public CommonResult<String> saveSysMenu(@RequestBody @Valid SysMenuVO sysMenuVO) throws Exception {
        return ((SysMenuManager)this.baseService).saveSysMenu(this.sysMenuConvert.toDTO(sysMenuVO));
    }

    @DeleteMapping(value={"/sysMenu/removeCascade/{id}"})
    @Operation(summary="\u6839\u636eid\u5220\u9664\u83dc\u5355\u548c\u4e0b\u7ea7\u83dc\u5355")
    @Parameter(name="id", description="\u83dc\u5355id", in=ParameterIn.PATH)
    public CommonResult<String> removeCascade(@PathVariable String id) {
        return ((SysMenuManager)this.baseService).removeCascade(id);
    }

    @GetMapping(value={"/sysMenus/currentUserMenu"})
    @Operation(summary="\u83b7\u53d6\u83dc\u5355\u6811", description="\u83b7\u53d6\u83dc\u5355\u6811")
    @Parameters(value={@Parameter(name="sysCode", description="\u7cfb\u7edf\u7f16\u7801", required=true, in=ParameterIn.QUERY), @Parameter(name="serverCode", description="\u670d\u52a1\u7f16\u7801(\u975e\u5fc5\u586b)", required=false, in=ParameterIn.QUERY), @Parameter(name="filterAlias", description="\u5ffd\u7565\u67e5\u8be2\u7684\u83dc\u5355\u522b\u540d(\u4e0b\u7ea7\u4e5f\u4f1a\u4e00\u8d77\u5ffd\u7565)", required=false, in=ParameterIn.QUERY)})
    public List<SysMenuVO> getCurrentUserMenu(@RequestParam String sysCode, @RequestParam Optional<String> serverCode, @RequestParam Optional<String> filterAlias) throws Exception {
        List lists = ((SysMenuManager)this.baseService).getCurrentUserMenu(sysCode, serverCode.orElse(""));
        lists = ((SysMenuManager)this.baseService).i18nSysMenu(lists);
        if (StrUtil.isNotEmpty((CharSequence)filterAlias.orElse(""))) {
            Set filterMenuAliasSet = Arrays.stream(filterAlias.orElse("").split(",")).collect(Collectors.toSet());
            lists = ((SysMenuManager)this.baseService).filterByMenuAlias(lists, filterMenuAliasSet);
        }
        return BeanUtil.listToTree((List)this.sysMenuConvert.toVOs((Collection)lists));
    }

    @GetMapping(value={"/getCurrentUserAsyncRoutes"})
    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u83dc\u5355\u8def\u7531\u4fe1\u606f", description="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u83dc\u5355\u8def\u7531\u4fe1\u606f")
    @Parameters(value={@Parameter(name="sysCode", description="\u7cfb\u7edf\u7f16\u7801", required=true, in=ParameterIn.QUERY), @Parameter(name="serverCode", description="\u670d\u52a1\u7f16\u7801(\u975e\u5fc5\u586b)", required=false, in=ParameterIn.QUERY), @Parameter(name="filterAlias", description="\u5ffd\u7565\u67e5\u8be2\u7684\u83dc\u5355\u522b\u540d(\u4e0b\u7ea7\u4e5f\u4f1a\u4e00\u8d77\u5ffd\u7565)", required=false, in=ParameterIn.QUERY)})
    public List<SysMenuRouterVO> getCurrentUserAsyncRoutes(@RequestParam String sysCode, @RequestParam Optional<String> serverCode, @RequestParam Optional<String> filterAlias) throws Exception {
        return ((SysMenuManager)this.baseService).getCurrentUserAsyncRoutes(sysCode, serverCode.orElse(""), filterAlias.orElse(""));
    }
}

