/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.runtime.controller.org;

import cn.hutool.core.util.ObjUtil;
import com.hotent.base.core.common.response.CommonResult;
import com.hotent.base.core.context.BaseContext;
import com.hotent.base.core.domain.page.PageList;
import com.hotent.base.core.domain.query.QueryFilter;
import com.hotent.base.core.enums.entity.QueryOP;
import com.hotent.base.mybatisplus.mvc.controller.BaseController;
import com.hotent.uc.core.org.manager.OrgManager;
import com.hotent.uc.core.org.manager.OrgUserManager;
import com.hotent.uc.core.org.model.OrgUser;
import com.hotent.uc.core.org.vo.AddUserJobVO;
import com.hotent.uc.core.org.vo.AddUserOrgPostVO;
import com.hotent.uc.core.org.vo.OrgSetChargeVO;
import com.hotent.uc.core.user.dto.UserOrgPostJobDTO;
import com.hotent.uc.core.user.vo.UserOrgIdsVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/orgUsers/v1"})
@Tag(name="\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\u63a7\u5236\u5668")
public class OrgUserController
extends BaseController<OrgUserManager, OrgUser> {
    @Resource
    BaseContext baseContext;
    @Resource
    OrgManager orgManager;

    @PostMapping(value={"/orgUser/addUserOrg"})
    @Operation(summary="\u7ed9\u7528\u6237\u5206\u914d\u7ec4\u7ec7", description="\u7ed9\u7528\u6237\u5206\u914d\u7ec4\u7ec7")
    public CommonResult<String> addUserOrg(@RequestBody AddUserOrgPostVO vo) throws Exception {
        return ((OrgUserManager)this.baseService).addUserOrg(vo.getUserIds(), vo.getOrgIds());
    }

    @PostMapping(value={"/orgUser/addUserPost"})
    @Operation(summary="\u7ed9\u7528\u6237\u5206\u914d\u5c97\u4f4d", description="\u7ed9\u7528\u6237\u5206\u914d\u5c97\u4f4d")
    public CommonResult<String> addUserPost(@RequestBody AddUserOrgPostVO vo) throws Exception {
        return ((OrgUserManager)this.baseService).addUserPost(vo.getUserIds(), vo.getPostIds());
    }

    @PostMapping(value={"/orgUser/addUserJob"})
    @Operation(summary="\u7ed9\u7528\u6237\u5206\u914d\u804c\u52a1", description="\u7ed9\u7528\u6237\u5206\u914d\u804c\u52a1")
    public CommonResult<String> addUserJob(@RequestBody AddUserJobVO vo) throws Exception {
        return ((OrgUserManager)this.baseService).addUserJob(vo.getUserIds(), vo.getJobIds(), vo.getOrgId());
    }

    @DeleteMapping(value={"/orgUser/removeOrgUser/{orgId}"})
    @Operation(summary="\u79fb\u9664\u7ec4\u7ec7\u4e0b\u7684\u7528\u6237\uff0c\u5305\u62ec\u5c97\u4f4d\u548c\u804c\u52a1", description="\u79fb\u9664\u7ec4\u7ec7\u4e0b\u7684\u7528\u6237\uff0c\u5305\u62ec\u5c97\u4f4d\u548c\u804c\u52a1")
    @Parameters(value={@Parameter(name="orgId", description="\u7ec4\u7ec7id", required=true, in=ParameterIn.PATH)})
    public CommonResult<String> removeOrgUser(@PathVariable String orgId, @RequestBody List<String> userIds) throws Exception {
        ((OrgUserManager)this.baseService).removeOrgUser(orgId, userIds);
        return CommonResult.ok();
    }

    @DeleteMapping(value={"/orgUser/removeUserOrg/{userId}"})
    @Operation(summary="\u79fb\u9664\u7528\u6237\u7684\u7ec4\u7ec7", description="\u79fb\u9664\u7528\u6237\u7684\u7ec4\u7ec7")
    @Parameters(value={@Parameter(name="userId", description="\u7528\u6237id", required=true, in=ParameterIn.PATH)})
    public CommonResult<String> removeUserOrg(@PathVariable String userId, @RequestBody List<String> orgIds) throws Exception {
        ((OrgUserManager)this.baseService).removeUserOrg(userId, orgIds);
        return CommonResult.ok();
    }

    @DeleteMapping(value={"/orgUser/removePostUser/{postId}"})
    @Operation(summary="\u79fb\u9664\u5c97\u4f4d\u4e0b\u7684\u7528\u6237\uff0c\u4f46\u662f\u7528\u6237\u8fd8\u5c5e\u4e8e\u5c97\u4f4d\u6240\u5728\u7ec4\u7ec7", description="\u79fb\u9664\u5c97\u4f4d\u4e0b\u7684\u7528\u6237\uff0c\u4f46\u662f\u7528\u6237\u8fd8\u5c5e\u4e8e\u5c97\u4f4d\u6240\u5728\u7ec4\u7ec7")
    @Parameters(value={@Parameter(name="postId", description="\u7ec4\u7ec7id", required=true, in=ParameterIn.PATH)})
    public CommonResult<String> removePostUser(@PathVariable String postId, @RequestBody List<String> userIds) throws Exception {
        ((OrgUserManager)this.baseService).removePostUser(postId, userIds);
        return CommonResult.ok();
    }

    @DeleteMapping(value={"/orgUser/removeJobUser/{orgId}/{jobId}"})
    @Operation(summary="\u79fb\u9664\u804c\u52a1\u4e0b\u7684\u7528\u6237\uff0c\u4f46\u662f\u7528\u6237\u8fd8\u5c5e\u4e8e\u8be5\u7ec4\u7ec7", description="\u79fb\u9664\u804c\u52a1\u4e0b\u7684\u7528\u6237\uff0c\u4f46\u662f\u7528\u6237\u8fd8\u5c5e\u4e8e\u6539\u7ec4\u7ec7")
    @Parameters(value={@Parameter(name="orgId", description="\u7ec4\u7ec7id", required=true, in=ParameterIn.PATH), @Parameter(name="jobId", description="\u804c\u52a1id", required=true, in=ParameterIn.PATH)})
    public CommonResult<String> removeJobUser(@PathVariable String orgId, @PathVariable String jobId, @RequestBody List<String> userIds) throws Exception {
        ((OrgUserManager)this.baseService).removeJobUser(orgId, jobId, userIds);
        return CommonResult.ok();
    }

    @PostMapping(value={"/orgUser/setMainOrg/{orgId}"})
    @Operation(summary="\u8bbe\u7f6e\u7528\u6237\u7684\u4e3b\u7ec4\u7ec7", description="\u8bbe\u7f6e\u7528\u6237\u7684\u4e3b\u7ec4\u7ec7")
    @Parameters(value={@Parameter(name="orgId", description="\u7ec4\u7ec7id", required=true, in=ParameterIn.PATH)})
    public CommonResult<String> setMainOrg(@PathVariable String orgId, @RequestBody List<String> userIds) throws Exception {
        ((OrgUserManager)this.baseService).setMainOrg(orgId, userIds);
        return CommonResult.ok();
    }

    @PostMapping(value={"/orgUser/setCharge"})
    @Operation(summary="\u8bbe\u7f6e\u7ec4\u7ec7\u8d1f\u8d23\u4eba", description="\u8bbe\u7f6e\u7ec4\u7ec7\u8d1f\u8d23\u4eba")
    public CommonResult<String> setCharge(@RequestBody OrgSetChargeVO vo) throws Exception {
        ((OrgUserManager)this.baseService).setCharge(vo.getOrgId(), vo.getUserId(), vo.getIsCharge());
        return CommonResult.ok();
    }

    @PostMapping(value={"/orgUsers/queryUserByOrg/{orgId}"})
    @Operation(summary="\u6839\u636e\u7ec4\u7ec7id\u67e5\u627e\u7ec4\u7ec7\u4e0b\u7684\u7528\u6237,\u5e76\u8fd4\u56de\u7528\u6237\u7684\u804c\u52a1\u5c97\u4f4d\u4fe1\u606f", description="\u6839\u636e\u7ec4\u7ec7id\u67e5\u627e\u7ec4\u7ec7\u4e0b\u7684\u7528\u6237")
    @Parameters(value={@Parameter(name="orgId", description="\u7ec4\u7ec7id", required=true, in=ParameterIn.PATH)})
    public PageList<UserOrgPostJobDTO> queryUserByOrg(@PathVariable String orgId, @RequestBody QueryFilter<OrgUser> filter) throws Exception {
        return ((OrgUserManager)this.baseService).queryUserByOrg(orgId, filter);
    }

    @PostMapping(value={"/orgUsers/queryUserByJob/{jobId}"})
    @Operation(summary="\u6839\u636e\u804c\u52a1id\u67e5\u627e\u804c\u52a1\u4e0b\u7684\u7528\u6237", description="\u6839\u636e\u804c\u52a1id\u67e5\u627e\u804c\u52a1\u4e0b\u7684\u7528\u6237")
    @Parameters(value={@Parameter(name="jobId", description="\u804c\u52a1id", required=true, in=ParameterIn.PATH)})
    public PageList<UserOrgPostJobDTO> queryUserByJob(@PathVariable String jobId, @RequestBody QueryFilter<OrgUser> filter) throws Exception {
        return ((OrgUserManager)this.baseService).queryUserByJob(jobId, filter);
    }

    @PostMapping(value={"/orgUser/queryUserByPost/{postId}"})
    @Operation(summary="\u6839\u636e\u5c97\u4f4did\u67e5\u8be2\u7528\u6237", description="\u6839\u636e\u5c97\u4f4did\u67e5\u8be2\u7528\u6237")
    @Parameters(value={@Parameter(name="postId", description="\u5c97\u4f4did", required=true, in=ParameterIn.PATH)})
    public PageList<UserOrgPostJobDTO> queryUserByPost(@PathVariable String postId, @RequestBody QueryFilter<UserOrgPostJobDTO> filter) throws Exception {
        return ((OrgUserManager)this.baseService).queryUserByPost(postId, filter);
    }

    @GetMapping(value={"/orgUser/getCurUserOrgIds"})
    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u90e8\u95e8\u4fe1\u606f\uff0c\u5305\u542b\u4e0b\u7ea7", description="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u90e8\u95e8\u4fe1\u606f\uff0c\u5305\u542b\u4e0b\u7ea7")
    public UserOrgIdsVO getCurUserOrgIds() throws Exception {
        UserOrgIdsVO vo = new UserOrgIdsVO();
        String currentUserId = this.baseContext.getCurrentUserId();
        QueryFilter filter = QueryFilter.build();
        filter.withOutPage();
        filter.addFilter("uou.user_id_", (Object)currentUserId, QueryOP.EQUAL);
        filter.addFilter("uo.is_dele_", (Object)"1", QueryOP.NOT_EQUAL);
        PageList userOrgData = ((OrgUserManager)this.baseService).queryUserOrgPostJob(filter, false);
        if (ObjUtil.isEmpty((Object)userOrgData.getRows())) {
            return vo;
        }
        Set<String> allOrgIds = userOrgData.getRows().stream().map(r -> r.getOrgId()).collect(Collectors.toSet());
        Set<String> mainOrgIds = userOrgData.getRows().stream().filter(r -> r.getIsMaster() == 1).map(r -> r.getOrgId()).collect(Collectors.toSet());
        vo.setAllOrgIds(List.copyOf(allOrgIds));
        vo.setMainOrgIds(List.copyOf(mainOrgIds));
        HashSet allOrgAndSubIds = new HashSet();
        HashSet mainOrgAndSubIds = new HashSet();
        mainOrgIds.forEach(o -> {
            List allChildByPId = this.orgManager.getAllChildByPId(o);
            if (ObjUtil.isNotEmpty((Object)allChildByPId)) {
                List<String> list = allChildByPId.stream().map(g -> g.getId()).toList();
                allOrgAndSubIds.addAll(list);
                mainOrgAndSubIds.addAll(list);
            }
        });
        allOrgIds.forEach(o -> {
            List allChildByPId;
            if (!mainOrgIds.contains(o) && ObjUtil.isNotEmpty((Object)(allChildByPId = this.orgManager.getAllChildByPId(o)))) {
                List<String> list = allChildByPId.stream().map(g -> g.getId()).toList();
                allOrgAndSubIds.addAll(list);
            }
        });
        vo.setMainAndSubOrgIds(List.copyOf(mainOrgAndSubIds));
        vo.setAllAndSubOrgIds(List.copyOf(allOrgAndSubIds));
        return vo;
    }
}

