/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.runtime.controller.role;

import com.hotent.base.core.common.response.CommonResult;
import com.hotent.base.core.domain.page.PageList;
import com.hotent.uc.core.annotation.CheckCodeExit;
import com.hotent.uc.core.annotation.LogOperateType;
import com.hotent.uc.core.common.enums.OperateTypeEnums;
import com.hotent.uc.core.role.manager.RoleManager;
import com.hotent.uc.core.role.mapstruct.RoleConvert;
import com.hotent.uc.core.role.model.Role;
import com.hotent.uc.core.role.vo.RoleVO;
import com.hotent.uc.runtime.controller.common.UcBaseController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/uc/roles/v1"})
@Tag(name="\u89d2\u8272\u7ba1\u7406\u63a7\u5236\u5668")
public class RoleController
extends UcBaseController<RoleManager, Role> {
    @Resource
    RoleConvert roleConvert;

    @GetMapping(value={"/role/detail/{code}"})
    @Operation(summary="\u6839\u636e\u7f16\u7801\u67e5\u8be2\u89d2\u8272\u8be6\u60c5", description="\u6839\u636e\u7f16\u7801\u67e5\u8be2\u89d2\u8272\u8be6\u60c5")
    @Parameters(value={@Parameter(name="code", description="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true, in=ParameterIn.PATH)})
    public RoleVO detail(@PathVariable String code) throws Exception {
        return this.roleConvert.toVO(((RoleManager)this.baseService).getByCode(code));
    }

    @PostMapping(value={"/role/add"})
    @Operation(summary="\u65b0\u589e\u89d2\u8272", description="\u65b0\u589e\u89d2\u8272")
    @CheckCodeExit(path="#roleVO.code", modelClass=Role.class)
    @LogOperateType(value=OperateTypeEnums.ADD)
    public CommonResult<String> addRole(@RequestBody @Valid RoleVO roleVO) throws Exception {
        ((RoleManager)this.baseService).save((Object)this.roleConvert.toDTO(roleVO));
        return CommonResult.ok();
    }

    @PostMapping(value={"/role/save"})
    @Operation(summary="\u66f4\u65b0\u89d2\u8272", description="\u66f4\u65b0\u89d2\u8272")
    @CheckCodeExit(path="#roleVO.code", modelClass=Role.class)
    @LogOperateType(value=OperateTypeEnums.EDIT)
    public CommonResult<String> saveRole(@RequestBody @Valid RoleVO roleVO) throws Exception {
        ((RoleManager)this.baseService).updateById((Object)this.roleConvert.toDTO(roleVO));
        return CommonResult.ok();
    }

    @GetMapping(value={"/role/updateEnabled"})
    @Operation(summary="\u66f4\u65b0\u89d2\u8272\u7684\u542f\u7528\u6216\u8005\u7981\u7528\u72b6\u6001", description="\u66f4\u65b0\u89d2\u8272\u7684\u542f\u7528\u6216\u8005\u7981\u7528\u72b6\u6001")
    @Parameters(value={@Parameter(name="ids", description="\u4e3b\u952e\u5b57\u7b26\u4e32", required=true, in=ParameterIn.QUERY), @Parameter(name="enabled", description="\u89d2\u8272\u72b6\u60010:\u7981\u7528\uff0c1:\u542f\u7528", required=true, in=ParameterIn.QUERY)})
    public CommonResult<String> updateEnabled(@RequestParam String ids, @RequestParam Integer enabled) throws Exception {
        ((RoleManager)this.baseService).updateEnabled(ids, enabled);
        return CommonResult.ok();
    }

    @PostMapping(value={"/queryRoleWithSelectorLog"})
    @Operation(summary="\u83b7\u53d6\u6700\u8fd1\u89d2\u8272\u5217\u8868(\u89d2\u8272\u9009\u62e9\u5668)", description="\u83b7\u53d6\u6700\u8fd1\u89d2\u8272\u5217\u8868(\u89d2\u8272\u9009\u62e9\u5668)")
    public PageList<RoleVO> queryRoleWithSelectorLog() throws Exception {
        return ((RoleManager)this.baseService).queryRoleWithSelectorLog();
    }

    @PostMapping(value={"/role/copyRight/{sourceId}"})
    @Operation(summary="\u590d\u5236\u89d2\u8272\u6743\u9650", description="\u590d\u5236\u89d2\u8272\u6743\u9650")
    @Parameters(value={@Parameter(name="sourceId", description="\u6e90\u89d2\u8272id", required=true, in=ParameterIn.PATH)})
    public CommonResult<String> copyRight(@PathVariable String sourceId, @RequestBody List<String> targetIds) throws Exception {
        ((RoleManager)this.baseService).copyRight(sourceId, targetIds);
        return CommonResult.ok();
    }

    @PostMapping(value={"/roles/import"})
    @Operation(summary="\u5bfc\u5165\u89d2\u8272", description="\u590d\u5236\u89d2\u8272\u6743\u9650")
    @Parameters(value={@Parameter(name="status", description="\u5b58\u5728\u7684\u89d2\u8272\u662f\u5426\u8986\u76d6", required=true, in=ParameterIn.PATH)})
    public CommonResult<String> importData(MultipartHttpServletRequest request, @RequestParam Optional<Boolean> isCover) throws Exception {
        return ((RoleManager)this.baseService).importData(request, isCover.orElse(false));
    }
}

