/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.runtime.controller.security;

import com.hotent.uc.core.security.manager.LoginLogManager;
import com.hotent.uc.core.security.service.SecurityCenterService;
import com.hotent.uc.core.security.vo.LoginDetailVO;
import com.hotent.uc.core.security.vo.LoginFrequencyVO;
import com.hotent.uc.core.security.vo.SecurityRiskVO;
import com.hotent.uc.core.user.model.User;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/security-center/v1"})
@Tag(name="\u5b89\u5168\u4e2d\u5fc3")
public class SecurityCenterController {
    @Resource
    LoginLogManager loginLogManager;
    @Resource
    SecurityCenterService securityCenterService;

    @GetMapping(value={"login/frequency"})
    @Operation(summary="\u767b\u5f55\u9891\u7387")
    @Parameters(value={@Parameter(name="startDate", description="\u5f00\u59cb\u65f6\u95f4", example="2024-09-18 00:00:00"), @Parameter(name="endDate", description="\u7ed3\u675f\u65f6\u95f4", example="2024-09-18 00:00:00")})
    public List<LoginFrequencyVO> getFrequency(@RequestParam String startDate, @RequestParam String endDate, @RequestParam Optional<Integer> limit) {
        return this.loginLogManager.getFrequency(startDate, endDate, limit.orElse(5));
    }

    @GetMapping(value={"login/detail"})
    @Operation(summary="\u767b\u5f55\u8be6\u60c5")
    public LoginDetailVO getLoginDetail() {
        return this.loginLogManager.getLoginDetail();
    }

    @GetMapping(value={"security-risk"})
    @Operation(summary="\u5b89\u5168\u98ce\u9669")
    public SecurityRiskVO getSecurityRisk() {
        return this.securityCenterService.getSecurityRisk();
    }

    @GetMapping(value={"login/exception/accounts"})
    @Operation(summary="\u5f02\u5e38\u767b\u5f55\u8d26\u53f7")
    public List<User> getAbnormalAccounts() {
        return this.securityCenterService.getAbnormalAccounts();
    }

    @GetMapping(value={"login/password-level-low/accounts"})
    @Operation(summary="\u5f02\u5e38\u767b\u5f55\u8d26\u53f7")
    public List<User> getPasswordLevelLowAccounts() {
        return this.securityCenterService.getPasswordLevelLowAccounts();
    }
}

