/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.runtime.controller.shift;

import com.alibaba.druid.util.StringUtils;
import com.hotent.base.core.common.response.CommonResult;
import com.hotent.base.core.domain.page.PageList;
import com.hotent.base.core.domain.query.QueryFilter;
import com.hotent.base.core.utils.BeanUtil;
import com.hotent.uc.core.shift.manager.ShiftRuleManager;
import com.hotent.uc.core.shift.manager.ShiftUserManager;
import com.hotent.uc.core.shift.model.ShiftRule;
import com.hotent.uc.core.shift.model.ShiftUser;
import com.hotent.uc.core.shift.vo.DurationVo;
import com.hotent.uc.core.shift.vo.ShiftRuleVo;
import com.hotent.uc.core.shift.vo.ShiftUserVo;
import com.hotent.uc.core.user.mapstruct.UserConvert;
import com.hotent.uc.core.user.model.User;
import com.hotent.uc.core.user.vo.UserOrgPostJobVO;
import com.hotent.uc.runtime.controller.common.UcBaseController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/shiftRule/v1/"})
@Tag(name="\u8f6e\u73ed\u89c4\u5219")
public class ShiftRuleController
extends UcBaseController<ShiftRuleManager, ShiftRule> {
    @Resource
    ShiftUserManager shiftUserManager;
    @Resource
    UserConvert userConvert;

    @PostMapping(value={"save"})
    @Operation(summary="\u65b0\u589e,\u66f4\u65b0\u8f6e\u73ed\u89c4\u5219\u6570\u636e", description="\u65b0\u589e,\u66f4\u65b0\u8f6e\u73ed\u89c4\u5219\u6570\u636e")
    @Parameter(name="ShiftRuleVo", description="\u8f6e\u73ed\u89c4\u5219Vo\u5bf9\u8c61", in=ParameterIn.QUERY)
    public CommonResult<String> save(@RequestBody ShiftRuleVo shiftRuleVo) throws Exception {
        ShiftRule checkShiftRule = ((ShiftRuleManager)this.baseService).getByCode((ShiftRule)shiftRuleVo.copyProperties(ShiftRule.class));
        if (BeanUtil.isNotEmpty((Object)checkShiftRule) && !StringUtils.equals((String)checkShiftRule.getId(), (String)shiftRuleVo.getId())) {
            return new CommonResult(false, "\u5df2\u5b58\u5728key\u4e3a" + checkShiftRule.getCode() + "\u7684\u8f6e\u73ed\u89c4\u5219\uff0c\u8bf7\u66f4\u6362key\u503c\uff01");
        }
        ((ShiftRuleManager)this.baseService).saveOrUpdate((Object)((ShiftRule)shiftRuleVo.copyProperties(ShiftRule.class)));
        return new CommonResult("\u64cd\u4f5c\u6210\u529f");
    }

    @DeleteMapping(value={"batch/removeByIds"})
    @Operation(summary="\u6279\u91cf\u5220\u9664\u8f6e\u73ed\u89c4\u5219\u8bb0\u5f55", description="\u6279\u91cf\u5220\u9664\u8f6e\u73ed\u89c4\u5219\u8bb0\u5f55")
    @Parameter(name="ids", description="\u4e1a\u52a1\u4e3b\u952e\u6570\u7ec4,\u591a\u4e2a\u4e1a\u52a1\u4e3b\u952e\u4e4b\u95f4\u7528\u9017\u53f7\u5206\u9694", in=ParameterIn.QUERY)
    public CommonResult<String> removes(String ... ids) throws Exception {
        ((ShiftRuleManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"save/shiftUsers"})
    @Operation(summary="\u4fdd\u5b58\u6392\u73ed\u4eba\u5458", description="\u4fdd\u5b58\u6392\u73ed\u4eba\u5458")
    @Parameter(name="shiftUserVos", description="\u6392\u73ed\u4eba\u5458\u6570\u7ec4", in=ParameterIn.QUERY)
    public CommonResult<String> saveShiftUser(@RequestBody @Valid ShiftUserVo shiftUserVo) {
        ArrayList<ShiftUser> users = new ArrayList<ShiftUser>();
        for (String userId : shiftUserVo.getUserId().split(",")) {
            users.add(new ShiftUser(shiftUserVo.getShiftId(), userId));
        }
        this.shiftUserManager.saveShiftUser(users);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @DeleteMapping(value={"batch/remove/shiftUserByUserIds/{shiftId}"})
    @Operation(summary="\u6839\u636e\u7528\u6237id\u6279\u91cf\u5220\u9664\u6392\u73ed\u7528\u6237", description="\u6839\u636e\u7528\u6237id\u6279\u91cf\u5220\u9664\u6392\u73ed\u7528\u6237")
    @Parameter(name="shiftId", description="\u8f6e\u73ed\u89c4\u5219id", in=ParameterIn.PATH)
    public CommonResult<String> removeShiftUser(@PathVariable String shiftId, @RequestBody List<String> ids) throws Exception {
        this.shiftUserManager.removeByUserIds(shiftId, ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"computeSendDate"}, produces={"application/json; charset=utf-8"})
    @Operation(summary="\u8ba1\u7b97\u53d1\u9001\u65f6\u95f4", description="\u8ba1\u7b97\u53d1\u9001\u65f6\u95f4")
    @Parameters(value={@Parameter(name="userId", description="\u7528\u6237id", in=ParameterIn.QUERY), @Parameter(name="minute", description="\u9ed8\u8ba4\u65f6\u957f", in=ParameterIn.QUERY)})
    public Long computeSendDate(@RequestParam(value="userId") String userId, @RequestParam(value="minute") long minute) throws Exception {
        return ((ShiftRuleManager)this.baseService).computeSendDate(userId, minute);
    }

    @PostMapping(value={"computeDuration"}, produces={"application/json; charset=utf-8"})
    @Operation(summary="\u8ba1\u7b97\u6301\u7eed\u65f6\u95f4", description="\u8ba1\u7b97\u6301\u7eed\u65f6\u95f4")
    @Parameters(value={@Parameter(name="userId", description="\u7528\u6237id", in=ParameterIn.QUERY), @Parameter(name="durationVo", description="\u8ba1\u7b97\u6301\u7eed\u65f6\u95f4Vo", in=ParameterIn.QUERY)})
    public Long computeDuration(@RequestParam(value="userId") String userId, @RequestBody DurationVo durationVo) throws Exception {
        return ((ShiftRuleManager)this.baseService).computeDuration(userId, durationVo.getStartDate(), durationVo.getEndDate());
    }

    @PostMapping(value={"/getUserByShiftId/{shiftId}"})
    @Operation(summary="\u6839\u636e\u8f6e\u73ed\u89c4\u5219id\u67e5\u8be2\u7528\u6237", description="\u6839\u636e\u8f6e\u73ed\u89c4\u5219id\u67e5\u8be2\u7528\u6237")
    @Parameters(value={@Parameter(name="shiftId", description="\u8f6e\u73ed\u89c4\u5219id", required=true, in=ParameterIn.PATH)})
    public PageList<UserOrgPostJobVO> getUserByShiftId(@PathVariable String shiftId, @RequestBody QueryFilter<User> filter) throws Exception {
        return ((ShiftRuleManager)this.baseService).getUserByShiftId(shiftId, filter).transRowsType(p -> this.userConvert.toOrgVO(p));
    }
}

