/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.runtime.controller.auth;

import cn.hutool.core.util.ObjUtil;
import com.hotent.base.auth.context.AuthenticationContextUtil;
import com.hotent.base.core.common.response.CommonResult;
import com.hotent.uc.core.auth.vo.LoginResponseEntity;
import com.hotent.uc.core.twofactor.manager.TwoFactorVerifyManager;
import com.hotent.uc.core.twofactor.vo.BindVO;
import com.hotent.uc.core.twofactor.vo.OneTimeCodeVO;
import com.hotent.uc.core.twofactor.vo.TwoFactorVerifyVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/two-factor-verify/v1/"})
@Tag(name="\u53cc\u56e0\u7d20\u8ba4\u8bc1\u7ba1\u7406")
public class TwoFactorVerifyController {
    @Resource
    TwoFactorVerifyManager twoFactorVerifyManager;

    @PostMapping(value={"init"})
    @Operation(summary="\u7528\u6237\u83b7\u53d6\u521d\u59cb\u5316\u53cc\u56e0\u7d20\u8ba4\u8bc1\u4fe1\u606f\uff08\u4e2a\u4eba\u8bbe\u7f6e\uff09", method="GET", description="\u7528\u6237\u83b7\u53d6\u521d\u59cb\u5316\u53cc\u56e0\u7d20\u8ba4\u8bc1\u4fe1\u606f\uff08\u4e2a\u4eba\u8bbe\u7f6e\uff09")
    public TwoFactorVerifyVO initTwoVerifyInfo() {
        return this.twoFactorVerifyManager.init(AuthenticationContextUtil.getCurrentUserAccout());
    }

    @GetMapping(value={"info"})
    @Operation(summary="\u7528\u6237\u83b7\u53d6\u81ea\u5df1\u7ed1\u5b9a\u7684\u53cc\u56e0\u7d20\u8ba4\u8bc1\u4fe1\u606f\uff08\u4e2a\u4eba\u8bbe\u7f6e\uff09", method="GET", description="\u7528\u6237\u83b7\u53d6\u81ea\u5df1\u7ed1\u5b9a\u7684\u53cc\u56e0\u7d20\u8ba4\u8bc1\u4fe1\u606f\uff08\u4e2a\u4eba\u8bbe\u7f6e\uff09")
    public CommonResult<TwoFactorVerifyVO> getTwoVerifyInfo() {
        TwoFactorVerifyVO twoFactorVerifyVO = this.twoFactorVerifyManager.get(AuthenticationContextUtil.getCurrentUserAccout());
        if (ObjUtil.isNull((Object)twoFactorVerifyVO)) {
            return CommonResult.success((Object)twoFactorVerifyVO).message("\u672a\u7ed1\u5b9a\u53cc\u56e0\u7d20\u8ba4\u8bc1\u4fe1\u606f");
        }
        return CommonResult.success((Object)twoFactorVerifyVO);
    }

    @PostMapping(value={"bind"})
    @Operation(summary="\u53cc\u56e0\u7d20\u6821\u9a8c\u5e76\u7ed1\u5b9a\uff08\u4e2a\u4eba\u8bbe\u7f6e\uff09", method="POST", description="\u9a8c\u8bc1&\u7ed1\u5b9a\u53cc\u56e0\u7d20\u9a8c\u8bc1\u7801\uff08\u4e2a\u4eba\u8bbe\u7f6e\uff09")
    @Parameters(value={@Parameter(name="code", description="\u53cc\u56e0\u7d20\u9a8c\u8bc1\u7801", required=true), @Parameter(name="secret", description="\u53cc\u56e0\u7d20\u5bc6\u94a5", required=true)})
    public List<OneTimeCodeVO> bindTwoStepVerifySecret(@RequestBody BindVO bindVO) throws Exception {
        return this.twoFactorVerifyManager.bind(AuthenticationContextUtil.getCurrentUserId(), bindVO.getCode(), bindVO.getSecret());
    }

    @PostMapping(value={"close"})
    @Operation(summary="\u5173\u95ed\u53cc\u56e0\u7d20\u6821\u9a8c", method="GET", description="\u5173\u95ed\u53cc\u56e0\u7d20\u6821\u9a8c\uff08\u4e2a\u4eba\u8bbe\u7f6e\uff09")
    public String closeTwoStepVerify() {
        this.twoFactorVerifyManager.close(AuthenticationContextUtil.getCurrentUserId());
        return "\u5173\u95ed\u6210\u529f";
    }

    @PostMapping(value={"verify"})
    @Operation(summary="\u53cc\u56e0\u7d20\u6821\u9a8c\uff08\u767b\u5f55\u9875\uff09", method="POST", description="\u53cc\u56e0\u7d20\u6821\u9a8c\uff08\u767b\u5f55\u9875\uff09")
    @Parameters(value={@Parameter(name="tokenTemp", description="\u4e34\u65f6token", required=true), @Parameter(name="code", description="\u53cc\u56e0\u7d20\u9a8c\u8bc1\u7801", required=true)})
    public LoginResponseEntity twoStepVerify(@RequestParam String tokenTemp, @RequestParam String code) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return this.twoFactorVerifyManager.verify(tokenTemp, code);
    }

    @RequestMapping(value={"twoStepVerifyAndBind"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @Operation(summary="\u53cc\u56e0\u7d20\u6821\u9a8c\u5e76\u7ed1\u5b9a\uff08\u767b\u5f55\u9875\u5f3a\u5236\u7ed1\u5b9a\uff09", method="POST", description="\u53cc\u56e0\u7d20\u6821\u9a8c\u5e76\u7ed1\u5b9a\uff08\u767b\u5f55\u9875\u5f3a\u5236\u7ed1\u5b9a\uff09")
    @Parameters(value={@Parameter(name="tokenTemp", description="\u4e34\u65f6token", required=true), @Parameter(name="code", description="\u53cc\u56e0\u7d20\u9a8c\u8bc1\u7801", required=true)})
    public List<OneTimeCodeVO> twoStepVerifyAndBind(@RequestParam String tokenTemp, @RequestParam String code) throws Exception {
        return this.twoFactorVerifyManager.verifyAndBind(tokenTemp, code);
    }
}

