/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.runtime.controller.org;

import cn.hutool.core.collection.CollUtil;
import com.hotent.base.core.common.response.CommonResult;
import com.hotent.base.core.domain.page.PageList;
import com.hotent.uc.core.annotation.CheckCodeExit;
import com.hotent.uc.core.org.manager.OrgManager;
import com.hotent.uc.core.org.mapstruct.OrgConvert;
import com.hotent.uc.core.org.model.Org;
import com.hotent.uc.core.org.vo.OrgMoreInfoVO;
import com.hotent.uc.core.org.vo.OrgTreeQueryVo;
import com.hotent.uc.core.org.vo.OrgVO;
import com.hotent.uc.runtime.controller.common.UcBaseController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/orgs/v1"})
@Tag(name="\u7ec4\u7ec7\u67b6\u6784\u63a7\u5236\u5668")
public class OrgController
extends UcBaseController<OrgManager, Org> {
    @Resource
    OrgConvert orgConvert;

    @GetMapping(value={"/detail/{id}"})
    @Operation(summary="\u7ec4\u7ec7\u67b6\u6784\u6570\u636e\u8be6\u60c5", description="\u7ec4\u7ec7\u67b6\u6784\u6570\u636e\u8be6\u60c5")
    @Parameters(value={@Parameter(name="id", description="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true, in=ParameterIn.PATH)})
    public OrgVO detail(@PathVariable String id) throws Exception {
        return (OrgVO)((Org)((OrgManager)this.baseService).get((Serializable)((Object)id))).copyProperties(OrgVO.class);
    }

    @GetMapping(value={"/org/moreInfo/{id}"})
    @Operation(summary="\u83b7\u53d6\u7ec4\u7ec7\u7684\u8be6\u7ec6\u4fe1\u606f(\u5305\u542b\u5206\u7ba1\u6388\u6743\u548c\u6269\u5c55\u53c2\u6570)", description="\u83b7\u53d6\u7ec4\u7ec7\u7684\u8be6\u7ec6\u4fe1\u606f(\u5305\u542b\u5206\u7ba1\u6388\u6743\u548c\u6269\u5c55\u53c2\u6570)")
    @Parameters(value={@Parameter(name="id", description="\u7ec4\u7ec7\u7f16\u7801", required=true, in=ParameterIn.PATH)})
    public OrgMoreInfoVO getMoreInfo(@PathVariable String id) throws Exception {
        return ((OrgManager)this.baseService).getMoreInfo(id);
    }

    @PostMapping(value={"/org/saveMore"})
    @Operation(summary="\u65b0\u589e\u6216\u4fdd\u5b58\u7ec4\u7ec7", description="\u65b0\u589e\u6216\u4fdd\u5b58\u7ec4\u7ec7")
    @CheckCodeExit(path="#moreInfoVO.org.code", modelClass=Org.class)
    public CommonResult<String> saveMore(@RequestBody @Valid OrgMoreInfoVO moreInfoVO) throws Exception {
        return ((OrgManager)this.baseService).saveOrg(moreInfoVO);
    }

    @PostMapping(value={"/orgs/getTreeByParentAndDem"})
    @Operation(summary="\u83b7\u53d6\u7ec4\u7ec7\u6811\uff08\u6839\u636e\u7ef4\u5ea6id\u6216\u4e0a\u7ea7\u7ec4\u7ec7id\uff09", description="\u83b7\u53d6\u7ec4\u7ec7\u6811\uff08\u6839\u636e\u7ef4\u5ea6id\u6216\u4e0a\u7ea7\u7ec4\u7ec7id\uff09")
    public List<OrgVO> getByParentAndDemToTree(@RequestBody OrgTreeQueryVo params) throws Exception {
        return ((OrgManager)this.baseService).getTreeByParentAndDem(params);
    }

    @DeleteMapping(value={"/org/removeCascade/{id}"})
    @Operation(summary="\u6839\u636eid\u5220\u9664\u83dc\u5355\u548c\u4e0b\u7ea7\u83dc\u5355")
    @Parameter(name="id", description="\u4e0a\u7ea7id", in=ParameterIn.PATH)
    public CommonResult<String> removeCascade(@PathVariable String id) {
        return ((OrgManager)this.baseService).removeCascade(id);
    }

    @PostMapping(value={"/queryOrgWithSelectorLog"})
    @Operation(summary="\u83b7\u53d6\u6700\u8fd1\u7ec4\u7ec7\u5217\u8868(\u7ec4\u7ec7\u9009\u62e9\u5668)", description="\u83b7\u53d6\u6700\u8fd1\u7ec4\u7ec7\u5217\u8868(\u7ec4\u7ec7\u9009\u62e9\u5668)")
    public PageList<OrgVO> queryOrgWithSelectorLog() throws Exception {
        return ((OrgManager)this.baseService).queryOrgWithSelectorLog();
    }

    @PostMapping(value={"/codes"})
    @Operation(summary="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\uff0c\u6279\u91cf\u83b7\u53d6\u7ec4\u7ec7\u4e0b\u7ea7\u7ec4\u7ec7", description="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\uff0c\u6279\u91cf\u83b7\u53d6\u7ec4\u7ec7\u4e0b\u7ea7\u7ec4\u7ec7")
    public List<OrgVO> getOrgsByCodes(@RequestBody List<String> codes) {
        if (CollUtil.isEmpty(codes)) {
            return List.of();
        }
        return ((OrgManager)this.baseService).getOrgsByCodes(codes);
    }
}

