/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.runtime.controller.org;

import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.hotent.base.core.common.response.CommonResult;
import com.hotent.base.core.context.UserIdentityTypeEnums;
import com.hotent.base.core.domain.page.PageList;
import com.hotent.base.core.domain.query.QueryFilter;
import com.hotent.base.core.enums.entity.QueryOP;
import com.hotent.uc.core.annotation.CheckCodeExit;
import com.hotent.uc.core.annotation.LogOperateModel;
import com.hotent.uc.core.annotation.LogOperateType;
import com.hotent.uc.core.common.enums.OperateTypeEnums;
import com.hotent.uc.core.org.manager.OrgJobManager;
import com.hotent.uc.core.org.manager.OrgJobRelationManager;
import com.hotent.uc.core.org.mapstruct.OrgJobConvert;
import com.hotent.uc.core.org.model.OrgJob;
import com.hotent.uc.core.org.model.OrgJobRelation;
import com.hotent.uc.core.org.vo.OrgJobVO;
import com.hotent.uc.runtime.controller.common.UcBaseController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/orgJobs/v1"})
@Tag(name="\u804c\u52a1\u5b9a\u4e49\u63a7\u5236\u5668")
@LogOperateModel(value=UserIdentityTypeEnums.JOB)
public class OrgJobController
extends UcBaseController<OrgJobManager, OrgJob> {
    @Resource
    OrgJobConvert orgJobConvert;
    @Resource
    OrgJobRelationManager orgJobRelationManager;

    @GetMapping(value={"/orgJob/detail/{id}"})
    @Operation(summary="\u804c\u52a1\u5b9a\u4e49\u6570\u636e\u8be6\u60c5", description="\u804c\u52a1\u5b9a\u4e49\u6570\u636e\u8be6\u60c5")
    @Parameters(value={@Parameter(name="id", description="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true, in=ParameterIn.PATH)})
    public OrgJobVO detail(@PathVariable String id) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("id_", (Object)id, QueryOP.EQUAL);
        PageList<OrgJobVO> list = this.list((QueryFilter<OrgJob>)queryFilter);
        if (ObjUtil.isNotEmpty((Object)list.getRows())) {
            return (OrgJobVO)list.getRows().get(0);
        }
        return null;
    }

    @PostMapping(value={"/orgJob/add"})
    @Operation(summary="\u65b0\u589e\u6216\u66f4\u65b0\u804c\u52a1", description="\u65b0\u589e\u6216\u66f4\u65b0\u804c\u52a1")
    @CheckCodeExit(path="#jobVO.code", modelClass=OrgJob.class)
    @LogOperateType(value=OperateTypeEnums.ADD)
    public CommonResult<String> addJob(@RequestBody @Valid OrgJobVO jobVO) throws Exception {
        return ((OrgJobManager)this.baseService).saveJob(jobVO);
    }

    @PostMapping(value={"/orgJob/update"})
    @Operation(summary="\u65b0\u589e\u6216\u66f4\u65b0\u804c\u52a1", description="\u65b0\u589e\u6216\u66f4\u65b0\u804c\u52a1")
    @CheckCodeExit(path="#jobVO.code", modelClass=OrgJob.class)
    @LogOperateType(value=OperateTypeEnums.EDIT)
    public CommonResult<String> updateJob(@RequestBody @Valid OrgJobVO jobVO) throws Exception {
        return ((OrgJobManager)this.baseService).saveJob(jobVO);
    }

    @PostMapping(value={"/orgJob/queryByOrgId/{orgId}"})
    @Operation(summary="\u67e5\u8be2\u7ec4\u7ec7\u4e0b\u7684\u804c\u52a1", description="\u67e5\u8be2\u7ec4\u7ec7\u4e0b\u7684\u804c\u52a1")
    @Parameters(value={@Parameter(name="orgId", description="\u7ec4\u7ec7id", required=true, in=ParameterIn.PATH)})
    public PageList<OrgJobVO> queryByOrgId(@PathVariable String orgId, @RequestBody QueryFilter<OrgJob> filter) throws Exception {
        return ((OrgJobManager)this.baseService).queryByOrgId(orgId, filter);
    }

    @PostMapping(value={"/queryJobWithSelectorLog"})
    @Operation(summary="\u83b7\u53d6\u6700\u8fd1\u7528\u6237\u5217\u8868(\u7528\u6237\u9009\u62e9\u5668)", description="\u83b7\u53d6\u6700\u8fd1\u7528\u6237\u5217\u8868(\u7528\u6237\u9009\u62e9\u5668)")
    public PageList<OrgJob> queryJobWithSelectorLog() throws Exception {
        return ((OrgJobManager)this.baseService).queryWithSelectorLog();
    }

    @PostMapping(value={"/list"}, produces={"application/json; charset=utf-8"})
    @Operation(summary="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<OrgJobVO> list(@RequestBody QueryFilter<OrgJob> queryFilter) {
        PageList query = super.query(queryFilter).transRowsType(r -> this.orgJobConvert.toVO(r));
        if (ObjUtil.isNotEmpty((Object)query.getRows())) {
            List<String> jobIds = query.getRows().stream().map(r -> r.getId()).toList();
            Map<String, List<OrgJobRelation>> jobMap = ((LambdaQueryChainWrapper)this.orgJobRelationManager.lambdaQuery().in(OrgJobRelation::getJobId, jobIds)).list().stream().filter(l -> StrUtil.isNotEmpty((CharSequence)l.getOrgName())).collect(Collectors.groupingBy(r -> r.getJobId()));
            query.getRows().forEach(j -> {
                List list = (List)jobMap.get(j.getId());
                if (ObjUtil.isNotEmpty((Object)list)) {
                    j.setOrgNames(StrUtil.join((CharSequence)",", list.stream().map(l -> l.getOrgName()).toList()));
                    j.setOrgIds(StrUtil.join((CharSequence)",", list.stream().map(l -> l.getOrgId()).toList()));
                }
            });
        }
        return query;
    }
}

