/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.runtime.controller.org;

import cn.hutool.core.util.ObjUtil;
import com.hotent.base.core.common.response.CommonResult;
import com.hotent.base.core.domain.page.PageList;
import com.hotent.base.core.domain.query.QueryFilter;
import com.hotent.base.core.enums.entity.QueryOP;
import com.hotent.uc.core.annotation.CheckCodeExit;
import com.hotent.uc.core.org.manager.OrgManager;
import com.hotent.uc.core.org.manager.OrgPostManager;
import com.hotent.uc.core.org.mapstruct.OrgPostConvert;
import com.hotent.uc.core.org.model.Org;
import com.hotent.uc.core.org.model.OrgPost;
import com.hotent.uc.core.org.vo.OrgPostVO;
import com.hotent.uc.runtime.controller.common.UcBaseController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/orgPosts/v1"})
@Tag(name="\u7ec4\u7ec7\u5c97\u4f4d\u63a7\u5236\u5668")
public class OrgPostController
extends UcBaseController<OrgPostManager, OrgPost> {
    @Resource
    OrgPostConvert orgPostConvert;
    @Resource
    OrgManager orgManager;

    @GetMapping(value={"/orgPost/detail/{id}"})
    @Operation(summary="\u7ec4\u7ec7\u5c97\u4f4d\u6570\u636e\u8be6\u60c5", description="\u7ec4\u7ec7\u5c97\u4f4d\u6570\u636e\u8be6\u60c5")
    @Parameters(value={@Parameter(name="id", description="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true, in=ParameterIn.PATH)})
    public OrgPostVO detail(@PathVariable String id) throws Exception {
        OrgPostVO orgPost = this.orgPostConvert.toVO((OrgPost)((OrgPostManager)this.baseService).get((Serializable)((Object)id)));
        if (ObjUtil.isEmpty((Object)orgPost)) {
            return orgPost;
        }
        Org org = (Org)this.orgManager.get((Serializable)((Object)orgPost.getOrgId()));
        if (ObjUtil.isNotEmpty((Object)orgPost)) {
            orgPost.setOrgName(org.getName());
        }
        return orgPost;
    }

    @PostMapping(value={"/orgPost/save"})
    @Operation(summary="\u65b0\u589e\u6216\u66f4\u65b0\u5c97\u4f4d", description="\u65b0\u589e\u6216\u66f4\u65b0\u5c97\u4f4d")
    @CheckCodeExit(path="#postVO.code", modelClass=OrgPost.class)
    public CommonResult<String> savePost(@RequestBody @Valid OrgPostVO postVO) throws Exception {
        return ((OrgPostManager)this.baseService).savePost(this.orgPostConvert.toDTO(postVO));
    }

    @PostMapping(value={"/orgPost/selectorQuery"})
    @Operation(summary="\u67e5\u67e5\u8be2\u5c97\u4f4d\u548c\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\uff0c\u5c97\u4f4d\u9009\u62e9\u5668\u7528", description="\u67e5\u8be2\u5c97\u4f4d\u548c\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\uff0c\u5c97\u4f4d\u9009\u62e9\u5668\u7528")
    public PageList<OrgPostVO> selectorQuery(@RequestBody QueryFilter<OrgPost> filter) throws Exception {
        filter.addFilter("SHOW_STATUS_", (Object)"1", QueryOP.EQUAL);
        return ((OrgPostManager)this.baseService).query(filter).transRowsType(p -> this.orgPostConvert.toVO(p));
    }

    @PostMapping(value={"/queryPostWithSelectorLog"})
    @Operation(summary="\u83b7\u53d6\u6700\u8fd1\u5c97\u4f4d\u5217\u8868(\u5c97\u4f4d\u9009\u62e9\u5668)", description="\u83b7\u53d6\u6700\u8fd1\u5c97\u4f4d\u5217\u8868(\u5c97\u4f4d\u9009\u62e9\u5668)")
    public PageList<OrgPostVO> queryPostWithSelectorLog() throws Exception {
        return ((OrgPostManager)this.baseService).queryPostWithSelectorLog();
    }

    @PostMapping(value={"/orgPost/changeBelongOrg/{orgId}"})
    @Operation(summary="\u53d8\u66f4\u5c97\u4f4d\u6240\u5c5e\u7ec4\u7ec7", description="\u53d8\u66f4\u5c97\u4f4d\u6240\u5c5e\u7ec4\u7ec7")
    @Parameters(value={@Parameter(name="orgId", description="\u7ec4\u7ec7id", required=true, in=ParameterIn.PATH)})
    public CommonResult<String> changeBelongOrg(@PathVariable String orgId, @RequestBody List<String> postIds) throws Exception {
        ((OrgPostManager)this.baseService).changeBelongOrg(orgId, postIds);
        return CommonResult.ok();
    }
}

