/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.runtime.controller.user;

import cn.hutool.core.util.ObjUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.core.common.response.CommonResult;
import com.hotent.base.core.context.BaseContext;
import com.hotent.base.core.utils.JsonUtil;
import com.hotent.base.mybatisplus.mvc.controller.BaseController;
import com.hotent.uc.core.user.manager.CustomSettingManager;
import com.hotent.uc.core.user.model.CustomSetting;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/customSettings/v1"})
@Tag(name="\u7528\u6237\u4e3b\u9898\u8bbe\u7f6e\u8868\u63a7\u5236\u5668")
public class CustomSettingController
extends BaseController<CustomSettingManager, CustomSetting> {
    @Resource
    BaseContext baseContext;

    @GetMapping(value={"/currentTheme"})
    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u4e3b\u9898\u8bbe\u7f6e", description="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u4e3b\u9898\u8bbe\u7f6e")
    public ObjectNode currentUserSetting() throws Exception {
        String currentUserId = this.baseContext.getCurrentUserId();
        CustomSetting setting = ((CustomSettingManager)this.baseService).getByUserId(currentUserId);
        if (ObjUtil.isNotEmpty((Object)setting)) {
            return (ObjectNode)JsonUtil.toJsonNode((String)setting.getTheme());
        }
        return null;
    }

    @PostMapping(value={"/saveTheme"})
    @Operation(summary="\u7528\u6237\u4e3b\u9898\u8bbe\u7f6e\u8868\u6570\u636e\u8be6\u60c5", description="\u7528\u6237\u4e3b\u9898\u8bbe\u7f6e\u8868\u6570\u636e\u8be6\u60c5")
    public CommonResult<String> save(@RequestBody ObjectNode data) throws Exception {
        String currentUserId = this.baseContext.getCurrentUserId();
        CustomSetting setting = ((CustomSettingManager)this.baseService).getByUserId(currentUserId);
        if (setting == null) {
            setting = new CustomSetting();
            setting.setUserId(currentUserId);
        }
        setting.setTheme(JsonUtil.toJsonString((Object)data));
        ((CustomSettingManager)this.baseService).saveOrUpdate((Object)setting);
        return CommonResult.ok();
    }

    @GetMapping(value={"/switchPost"})
    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u4e3b\u9898\u8bbe\u7f6e", description="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u4e3b\u9898\u8bbe\u7f6e")
    public CommonResult<String> switchPost(@RequestParam String postId) throws Exception {
        String currentUserId = this.baseContext.getCurrentUserId();
        CustomSetting setting = ((CustomSettingManager)this.baseService).getByUserId(currentUserId);
        if (setting == null) {
            setting = new CustomSetting();
            setting.setUserId(currentUserId);
        }
        setting.setPostId(postId);
        ((CustomSettingManager)this.baseService).saveOrUpdate((Object)setting);
        return CommonResult.ok();
    }
}

