/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.runtime.controller.user;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.hotent.base.core.common.exception.bean.BaseException;
import com.hotent.base.core.common.response.CommonResult;
import com.hotent.base.core.context.BaseContext;
import com.hotent.base.core.context.UserIdentityTypeEnums;
import com.hotent.base.core.domain.page.PageList;
import com.hotent.base.core.domain.query.QueryFilter;
import com.hotent.base.core.enums.entity.FieldRelation;
import com.hotent.base.core.enums.entity.QueryOP;
import com.hotent.base.core.utils.HttpUtil;
import com.hotent.uc.core.annotation.LogOperateModel;
import com.hotent.uc.core.annotation.LogOperateType;
import com.hotent.uc.core.bytearray.manager.BytearrayManager;
import com.hotent.uc.core.bytearray.model.Bytearray;
import com.hotent.uc.core.common.enums.OperateTypeEnums;
import com.hotent.uc.core.user.manager.ElectronicSealManager;
import com.hotent.uc.core.user.manager.UserImportManager;
import com.hotent.uc.core.user.manager.UserManager;
import com.hotent.uc.core.user.mapstruct.UserConvert;
import com.hotent.uc.core.user.model.ElectronicSeal;
import com.hotent.uc.core.user.model.User;
import com.hotent.uc.core.user.vo.AppUserInfoVO;
import com.hotent.uc.core.user.vo.BasicUserVO;
import com.hotent.uc.core.user.vo.UpdatePwdAndSealVO;
import com.hotent.uc.core.user.vo.UpdatePwdBaseVo;
import com.hotent.uc.core.user.vo.UpdatePwdVo;
import com.hotent.uc.core.user.vo.UserMoreInfoVO;
import com.hotent.uc.core.user.vo.UserOrgPostJobVO;
import com.hotent.uc.core.user.vo.UserVO;
import com.hotent.uc.core.util.RSAUtil;
import com.hotent.uc.runtime.controller.common.UcBaseController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/uc/users/v1"})
@Tag(name="\u7528\u6237\u7ba1\u7406\u63a7\u5236\u5668")
@LogOperateModel(value=UserIdentityTypeEnums.USER)
public class UserController
extends UcBaseController<UserManager, User> {
    @Resource
    BaseContext baseContext;
    @Resource
    UserConvert userConvert;
    @Resource
    ResourceLoader resourceLoader;
    @Resource
    UserImportManager userImportManager;
    @Resource
    BytearrayManager bytearrayManager;
    @Autowired
    ElectronicSealManager electronicSealManager;

    @GetMapping(value={"/user/detail/{account}"})
    @Operation(summary="\u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u7528\u6237\u5bf9\u8c61", description="\u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u7528\u6237\u5bf9\u8c61")
    @Parameters(value={@Parameter(name="account", description="\u7528\u6237\u8d26\u53f7", required=true, in=ParameterIn.PATH)})
    public UserVO getByAccount(@PathVariable String account) throws Exception {
        return this.userConvert.toVO(((UserManager)this.baseService).getByAccount(account));
    }

    @GetMapping(value={"/user/getById/{id}"})
    @Operation(summary="\u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u7528\u6237\u5bf9\u8c61", description="\u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u7528\u6237\u5bf9\u8c61")
    @Parameters(value={@Parameter(name="id", description="\u7528\u6237id", required=true, in=ParameterIn.PATH)})
    public UserVO getByUserId(@PathVariable String id) throws Exception {
        return this.userConvert.toVO((User)((UserManager)this.baseService).get((Serializable)((Object)id)));
    }

    @PostMapping(value={"/user/updatePwd"})
    @Operation(summary="\u7ba1\u7406\u5458\u4fee\u6539\u7528\u6237\u5bc6\u7801", description="\u7ba1\u7406\u5458\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    public CommonResult<String> updateUserPwd(@RequestBody UpdatePwdVo updatePwdVo) throws Exception {
        updatePwdVo.setNewPwd(RSAUtil.Decrypt((String)updatePwdVo.getNewPwd()));
        updatePwdVo.setOldPwd(RSAUtil.Decrypt((String)updatePwdVo.getOldPwd()));
        return ((UserManager)this.baseService).updateUserPwd(updatePwdVo);
    }

    @PostMapping(value={"/user/updatePwdAndSeal"})
    @Operation(summary="\u66f4\u65b0\u5bc6\u7801\u548c\u7b7e\u7ae0", description="\u66f4\u65b0\u5bc6\u7801\u548c\u7b7e\u7ae0")
    @LogOperateType(value=OperateTypeEnums.ADD)
    public CommonResult<String> updatePwdAndSeal(@Valid @RequestBody UpdatePwdAndSealVO vo) throws Exception {
        vo.setNewPwd(RSAUtil.Decrypt((String)vo.getNewPwd()));
        vo.setOldPwd(RSAUtil.Decrypt((String)vo.getOldPwd()));
        return ((UserManager)this.baseService).updatePwdAndSeal(vo);
    }

    @PostMapping(value={"/user/userUpdatePwd"})
    @Operation(summary="\u66f4\u65b0\u5bc6\u7801\u548c\u7b7e\u7ae0", description="\u66f4\u65b0\u5bc6\u7801\u548c\u7b7e\u7ae0")
    @LogOperateType(value=OperateTypeEnums.ADD)
    public CommonResult<String> userUpdatePwd(@Valid @RequestBody UpdatePwdBaseVo vo) throws Exception {
        vo.setNewPwd(RSAUtil.Decrypt((String)vo.getNewPwd()));
        vo.setOldPwd(RSAUtil.Decrypt((String)vo.getOldPwd()));
        return ((UserManager)this.baseService).userUpdatePwd(vo);
    }

    @GetMapping(value={"/user/moreInfo"})
    @Operation(summary="\u83b7\u53d6\u7528\u6237\u7684\u8be6\u7ec6\u4fe1\u606f(\u5305\u542b\u6240\u5c5e\u89d2\u8272\uff0c\u7ec4\u7ec7\uff0c\u5c97\u4f4d)", description="\u83b7\u53d6\u7528\u6237\u7684\u8be6\u7ec6\u4fe1\u606f(\u5305\u542b\u6240\u5c5e\u89d2\u8272\uff0c\u7ec4\u7ec7\uff0c\u5c97\u4f4d)")
    @Parameters(value={@Parameter(name="account", description="\u7528\u6237\u8d26\u53f7", required=true, in=ParameterIn.QUERY)})
    public UserMoreInfoVO getUserMoreInfo(@RequestParam String account) throws Exception {
        return ((UserManager)this.baseService).getUserMoreInfo(account);
    }

    @GetMapping(value={"/user/getCurrentUserInfo"})
    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f", description="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f")
    public AppUserInfoVO getCurrentUserInfo() throws Exception {
        return ((UserManager)this.baseService).getAppUserInfo(this.baseContext.getCurrentUserAccout());
    }

    @PostMapping(value={"/user/addMore"})
    @Operation(summary="\u65b0\u589e\u7528\u6237(\u5305\u542b\u89d2\u8272,\u7ec4\u7ec7,\u5c97\u4f4d\u7b49)", description="\u65b0\u589e\u7528\u6237(\u5305\u542b\u89d2\u8272,\u7ec4\u7ec7,\u5c97\u4f4d\u7b49)")
    @LogOperateType(value=OperateTypeEnums.ADD)
    public CommonResult<String> addMore(@RequestBody UserMoreInfoVO userVo) throws Exception {
        UserVO user = userVo.getUser();
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.put("\u8d26\u53f7", user.getAccount());
        checkMap.put("\u624b\u673a\u53f7", user.getMobile());
        checkMap.put("\u90ae\u7bb1", user.getEmail());
        checkMap.put("\u8eab\u4efd\u8bc1", user.getIdCard());
        for (Map.Entry entry : checkMap.entrySet()) {
            CommonResult<String> checkResult = this.checkEixt((String)entry.getKey(), entry.getValue(), "");
            if (checkResult == null) continue;
            return checkResult;
        }
        return ((UserManager)this.baseService).saveUserMoreInfo(userVo);
    }

    @PostMapping(value={"/user/saveBasic"})
    @Operation(summary="\u4fee\u6539\u5f53\u524d\u7528\u6237\u4e00\u4e9b\u57fa\u672c\u4fe1\u606f", description="\u4fee\u6539\u5f53\u524d\u7528\u6237\u4e00\u4e9b\u57fa\u672c\u4fe1\u606f")
    @LogOperateType(value=OperateTypeEnums.ADD)
    public CommonResult<String> saveBasic(@RequestBody BasicUserVO user) throws Exception {
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.put("\u624b\u673a\u53f7", user.getMobile());
        checkMap.put("\u90ae\u7bb1", user.getEmail());
        checkMap.put("\u8eab\u4efd\u8bc1", user.getIdCard());
        for (Map.Entry entry : checkMap.entrySet()) {
            CommonResult<String> checkResult = this.checkEixt((String)entry.getKey(), entry.getValue(), this.baseContext.getCurrentUserId());
            if (checkResult == null) continue;
            return checkResult;
        }
        return ((UserManager)this.baseService).saveBasic(user);
    }

    private CommonResult<String> checkEixt(String desc, Object value, String userId) {
        if (ObjUtil.isEmpty((Object)value)) {
            return null;
        }
        QueryFilter userFilter = QueryFilter.build();
        userFilter.addFilter("account_", value, QueryOP.EQUAL, FieldRelation.OR, "custom");
        userFilter.addFilter("mobile_", value, QueryOP.EQUAL, FieldRelation.OR, "custom");
        userFilter.addFilter("email_", value, QueryOP.EQUAL, FieldRelation.OR, "custom");
        userFilter.addFilter("id_card_", value, QueryOP.EQUAL, FieldRelation.OR, "custom");
        userFilter.withOutPage();
        PageList query = ((UserManager)this.baseService).queryWithLogicDelete(userFilter);
        if (ObjUtil.isEmpty((Object)query.getRows())) {
            return null;
        }
        for (User user : query.getRows()) {
            if (StrUtil.isNotEmpty((CharSequence)userId) && userId.equals(user.getId())) {
                return null;
            }
            if (!"1".equals(user.getIsDelete()) || !StrUtil.isEmpty((CharSequence)userId)) continue;
            CommonResult message = CommonResult.ok().message(String.format("%s[%s]\u5df2\u5b58\u5728\u5e76\u88ab\u5220\u9664\uff0c\u662f\u5426\u6062\u590d\uff1f", desc, value));
            message.setErrorCode("4005");
            message.setValue((Object)user.getId());
            return message;
        }
        throw new BaseException(String.format("%s[%s]\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01", desc, value));
    }

    @PostMapping(value={"/user/updateMore"})
    @Operation(summary="\u4fee\u6539\u7528\u6237(\u5305\u542b\u89d2\u8272,\u7ec4\u7ec7,\u5c97\u4f4d\u7b49)", description="\u4fee\u6539\u7528\u6237(\u5305\u542b\u89d2\u8272,\u7ec4\u7ec7,\u5c97\u4f4d\u7b49)")
    @LogOperateType(value=OperateTypeEnums.EDIT)
    public CommonResult<String> updateMore(@RequestBody UserMoreInfoVO userVo) throws Exception {
        UserVO user = userVo.getUser();
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.put("\u624b\u673a\u53f7", user.getMobile());
        checkMap.put("\u90ae\u7bb1", user.getEmail());
        checkMap.put("\u8eab\u4efd\u8bc1", user.getIdCard());
        for (Map.Entry entry : checkMap.entrySet()) {
            CommonResult<String> checkResult = this.checkEixt((String)entry.getKey(), entry.getValue(), user.getId());
            if (checkResult == null) continue;
            return checkResult;
        }
        return ((UserManager)this.baseService).saveUserMoreInfo(userVo);
    }

    @PostMapping(value={"/users/queryUserWithOrg"})
    @Operation(summary="\u67e5\u8be2\u7528\u6237\u548c\u7ec4\u7ec7\u4fe1\u606f\uff08\u7528\u6237\u9009\u62e9\u5668\u63a5\u53e3\uff09", description="\u67e5\u8be2\u7528\u6237\u548c\u7ec4\u7ec7\u4fe1\u606f\uff08\u7528\u6237\u9009\u62e9\u5668\u63a5\u53e3\uff09")
    public PageList<UserOrgPostJobVO> queryUserWithOrg(@RequestBody QueryFilter<User> filter) throws Exception {
        return ((UserManager)this.baseService).queryUserWithOrg(filter).transRowsType(p -> this.userConvert.toOrgVO(p));
    }

    @PostMapping(value={"/queryUserWithSelectorLog"})
    @Operation(summary="\u83b7\u53d6\u6700\u8fd1\u7528\u6237\u5217\u8868(\u7528\u6237\u9009\u62e9\u5668)", description="\u83b7\u53d6\u6700\u8fd1\u7528\u6237\u5217\u8868(\u7528\u6237\u9009\u62e9\u5668)")
    public PageList<UserOrgPostJobVO> queryUserWithSelectorLog() throws Exception {
        return ((UserManager)this.baseService).queryUserWithSelectorLog();
    }

    @PostMapping(value={"/importSignature"})
    @Operation(summary="\u6279\u91cf\u5bfc\u5165\u7b7e\u7ae0", description="\u6279\u91cf\u5bfc\u5165\u7b7e\u7ae0")
    public CommonResult<String> importSignature(@RequestBody MultipartFile file, @RequestParam Optional<Boolean> repeatConver) throws Exception {
        return ((UserManager)this.baseService).importSignature(file, repeatConver.orElse(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/downloadTemplate"})
    @Operation(summary="\u4e0b\u8f7d\u6a21\u677f", description="\u4e0b\u8f7d\u6a21\u677f")
    public void export(HttpServletResponse response) throws Exception {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("template/importOrgUser.xlsx");
        XSSFWorkbook workBook = new XSSFWorkbook(inputStream);
        String filedisplay = URLEncoder.encode("\u7528\u6237\u5bfc\u5165\u6a21\u677f.xlsx", "utf-8");
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
        response.addHeader("filename", filedisplay);
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
            workBook.write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                os.close();
            }
            workBook.close();
        }
    }

    @PostMapping(value={"users/importExcelUser"})
    @Operation(summary="\u5bfc\u5165Excel\u7528\u6237", description="\u5bfc\u5165Excel\u7528\u6237")
    @Parameters(value={@Parameter(name="importDemId", description="\u5bfc\u5165\u7684\u7ef4\u5ea6\u7f16\u7801", required=true, in=ParameterIn.QUERY), @Parameter(name="file", description="\u5bfc\u5165\u7684\u6587\u4ef6", required=true, in=ParameterIn.QUERY), @Parameter(name="repeatConver", description="\u662f\u5426\u8986\u76d6\u5bfc\u5165", required=true, in=ParameterIn.QUERY)})
    public CommonResult<String> importExcelUser(@RequestParam String importDemId, @RequestBody MultipartFile file, @RequestParam Optional<Boolean> repeatConver) throws Exception {
        return this.userImportManager.importExcelUser(file, importDemId, repeatConver.orElse(false).booleanValue());
    }

    @PostMapping(value={"user/excelExport"})
    @Operation(summary="\u5bfc\u51fa\u7528\u6237", description="\u5bfc\u51fa\u7528\u6237")
    public void excelExport(@RequestBody List<String> users, HttpServletResponse httpServletResponse) throws Exception {
        this.userImportManager.userExport(users, httpServletResponse);
    }

    @GetMapping(value={"/user/avatar/{userId}"})
    @Operation(summary="\u6839\u636e\u7528\u6237id\uff0c\u83b7\u53d6\u7528\u6237\u5934\u50cf", description="\u6839\u636e\u7528\u6237id\uff0c\u83b7\u53d6\u7528\u6237\u5934\u50cf")
    @Parameters(value={@Parameter(name="userId", description="\u7528\u6237id", required=true, in=ParameterIn.PATH)})
    public CommonResult<String> getAvatar(@PathVariable String userId) throws Exception {
        Bytearray byt;
        String photoByte = "";
        User user = (User)((UserManager)this.baseService).get((Serializable)((Object)userId));
        if (ObjUtil.isNotEmpty((Object)user) && StrUtil.isNotEmpty((CharSequence)user.getPhoto()) && (byt = (Bytearray)this.bytearrayManager.get((Serializable)((Object)user.getPhoto()))) != null) {
            photoByte = Base64.encode((byte[])byt.getBytes());
        }
        return CommonResult.ok().value((Object)photoByte);
    }

    @GetMapping(value={"/user/signature/{userId}"})
    @Operation(summary="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7b7e\u7ae0\u56fe\u7247", description="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7b7e\u7ae0\u56fe\u7247")
    @Parameters(value={@Parameter(name="userId", description="\u7528\u6237id", required=true, in=ParameterIn.PATH)})
    public String signature(@PathVariable String userId) throws Exception {
        List seal = ((LambdaQueryChainWrapper)this.electronicSealManager.lambdaQuery().eq(ElectronicSeal::getUserId, (Object)userId)).list();
        if (ObjUtil.isEmpty((Object)seal)) {
            return "";
        }
        String signature = "";
        Bytearray byt = (Bytearray)this.bytearrayManager.get((Serializable)((Object)((ElectronicSeal)seal.get(0)).getFileId()));
        if (byt != null) {
            signature = Base64.encode((byte[])byt.getBytes());
        }
        return signature;
    }

    @PostMapping(value={"/user/validSignaturePwd"})
    @Operation(summary="\u9a8c\u8bc1\u7528\u6237\u7b7e\u7ae0\u5bc6\u7801", description="\u9a8c\u8bc1\u7528\u6237\u7b7e\u7ae0\u5bc6\u7801")
    public boolean validSignaturePwd(@RequestBody String pwd) throws Exception {
        String currentUserId = this.baseContext.getCurrentUserId();
        List seal = ((LambdaQueryChainWrapper)this.electronicSealManager.lambdaQuery().eq(ElectronicSeal::getUserId, (Object)currentUserId)).list();
        if (ObjUtil.isEmpty((Object)seal)) {
            throw new BaseException("\u5f53\u524d\u7528\u6237\u5c1a\u672a\u914d\u7f6e\u7b7e\u7ae0");
        }
        String password = ((ElectronicSeal)seal.get(0)).getPassword();
        return password.equals(RSAUtil.Decrypt((String)pwd));
    }

    @GetMapping(value={"/user/signatureConfig"})
    @Operation(summary="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7b7e\u7ae0\u56fe\u7247", description="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7b7e\u7ae0\u56fe\u7247")
    public ElectronicSeal signatureConfig() throws Exception {
        String userId = this.baseContext.getCurrentUserId();
        List seal = ((LambdaQueryChainWrapper)this.electronicSealManager.lambdaQuery().eq(ElectronicSeal::getUserId, (Object)userId)).list();
        if (ObjUtil.isEmpty((Object)seal)) {
            return null;
        }
        ElectronicSeal electronicSeal = (ElectronicSeal)seal.get(0);
        ElectronicSeal config = new ElectronicSeal();
        config.setAllowFree(electronicSeal.getAllowFree());
        if (config.getAllowFree() == 0) {
            return config;
        }
        String ipAddr = HttpUtil.getIpAddr((HttpServletRequest)HttpUtil.getRequest());
        if (!ipAddr.equals(electronicSeal.getSetIp())) {
            return config;
        }
        if (electronicSeal.getIsFree() == 1) {
            if (electronicSeal.getSetTime().plusMonths(1L).isAfter(LocalDateTime.now())) {
                config.setIsFree(Integer.valueOf(1));
            }
        } else if (electronicSeal.getSetTime().plusMonths(1L).isAfter(LocalDateTime.now())) {
            config.setHideConfirm(electronicSeal.getHideConfirm());
        }
        return config;
    }

    @PostMapping(value={"/user/updateSignatureConfig"})
    @Operation(summary="\u66f4\u65b0\u7b7e\u7ae0\u8bbe\u7f6e", description="\u66f4\u65b0\u7b7e\u7ae0\u8bbe\u7f6e")
    public CommonResult<String> updateSignatureConfig(@RequestBody ElectronicSeal config) throws Exception {
        String userId = this.baseContext.getCurrentUserId();
        List seal = ((LambdaQueryChainWrapper)this.electronicSealManager.lambdaQuery().eq(ElectronicSeal::getUserId, (Object)userId)).list();
        if (ObjUtil.isEmpty((Object)seal)) {
            return null;
        }
        ElectronicSeal electronicSeal = (ElectronicSeal)seal.get(0);
        electronicSeal.setHideConfirm(config.getHideConfirm());
        electronicSeal.setSetTime(LocalDateTime.now());
        electronicSeal.setIsFree(config.getIsFree());
        String ipAddr = HttpUtil.getIpAddr((HttpServletRequest)HttpUtil.getRequest());
        electronicSeal.setSetIp(ipAddr);
        this.electronicSealManager.update((Model)electronicSeal);
        return CommonResult.ok();
    }
}

