/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.sdk.feign.config;

import cn.hutool.core.util.StrUtil;
import com.hotent.base.core.utils.HttpUtil;
import com.hotent.uc.sdk.feign.service.UcSdkService;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.cloud.openfeign.clientconfig.FeignClientConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.i18n.LocaleContextHolder;

public class UcSdkFeinConfig
implements FeignClientConfigurer {
    private static final String HEADER_AUTHORIZATION = "Authorization";

    @Bean
    public RequestInterceptor requestInterceptor() {
        return new RequestInterceptor(){

            public void apply(RequestTemplate requestTemplate) {
                HttpServletRequest httpServletRequest = HttpUtil.getRequest();
                if (httpServletRequest == null) {
                    return;
                }
                String token = UcSdkService.getThreadToken();
                if (StrUtil.isNotEmpty((CharSequence)token)) {
                    requestTemplate.header(UcSdkFeinConfig.HEADER_AUTHORIZATION, new String[]{token});
                }
                requestTemplate.header("from_feign", new String[]{"true"});
                String tenantId = httpServletRequest.getParameter("tenantId");
                if (StrUtil.isNotEmpty((CharSequence)tenantId)) {
                    requestTemplate.query("tenantId", new String[]{tenantId});
                }
                requestTemplate.query("tenantId", new String[]{tenantId});
                requestTemplate.header("Accept-Language", new String[]{LocaleContextHolder.getLocale().toLanguageTag()});
            }
        };
    }

    public boolean inheritParentConfiguration() {
        return false;
    }
}

