/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.sdk.feign.service;

import cn.hutool.core.util.StrUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hotent.uc.sdk.feign.properties.UcSdkProperty;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class UcSdkService {
    UcSdkProperty ucSdkProperty;
    private static final ThreadLocal<String> threadLocalToken = new ThreadLocal();
    private static final String UNDERLINE = "_";
    private final Cache<String, String> tokenCache;

    public UcSdkService(UcSdkProperty ucSdkProperty) {
        this.ucSdkProperty = ucSdkProperty;
        long tokenTimeout = ucSdkProperty.getTokenTimeout();
        this.tokenCache = Caffeine.newBuilder().expireAfterWrite(tokenTimeout, TimeUnit.MINUTES).maximumSize(10000L).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(String currentUserAccount, Supplier<T> supplier) throws Exception {
        try {
            this.getToken(this.ucSdkProperty.getSysCode(), this.ucSdkProperty.getSecretKey(), currentUserAccount);
            T t = supplier.get();
            return t;
        }
        finally {
            this.clearThreadToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(String currentUserAccount, Supplier<T> supplier, Consumer<Exception> consumer) throws Exception {
        T result = null;
        try {
            this.getToken(this.ucSdkProperty.getSysCode(), this.ucSdkProperty.getSecretKey(), currentUserAccount);
            result = supplier.get();
        }
        catch (Exception e) {
            consumer.accept(e);
        }
        finally {
            this.clearThreadToken();
        }
        return result;
    }

    public void getToken(String sysCode, String secretKey, String account) {
        StringJoiner tokenCacheKey = new StringJoiner(UNDERLINE);
        tokenCacheKey.add(sysCode);
        tokenCacheKey.add(secretKey);
        tokenCacheKey.add(account);
        String token = this.setToken2Cache(tokenCacheKey.toString());
        if (StrUtil.isEmptyIfStr((Object)token)) {
            // empty if block
        }
    }

    private String setToken2Cache(String tokenCacheKey) {
        String token = (String)this.tokenCache.getIfPresent((Object)tokenCacheKey);
        if (StrUtil.isNotEmpty((CharSequence)token)) {
            threadLocalToken.set(token);
        }
        return token;
    }

    public void clearThreadToken() {
        threadLocalToken.remove();
    }

    public static String getThreadToken() {
        return threadLocalToken.get();
    }
}

