/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.websocket.server;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.core.context.BaseContext;
import com.hotent.base.core.utils.AppUtil;
import com.hotent.base.core.utils.JsonUtil;
import com.hotent.base.websocket.annotations.HandshakeBefore;
import com.hotent.base.websocket.annotations.OnClose;
import com.hotent.base.websocket.annotations.OnError;
import com.hotent.base.websocket.annotations.OnEvent;
import com.hotent.base.websocket.annotations.OnMessage;
import com.hotent.base.websocket.annotations.OnOpen;
import com.hotent.base.websocket.annotations.PathParam;
import com.hotent.base.websocket.annotations.WsServerEndpoint;
import com.hotent.base.websocket.socket.Session;
import com.hotent.uc.event.manager.UcSystemEventTaskHiManager;
import com.hotent.uc.event.manager.UcSystemEventTaskManager;
import com.hotent.uc.event.manager.WsBusSystemManager;
import com.hotent.uc.event.model.UcSystemEventTask;
import com.hotent.uc.event.model.UcSystemEventTaskHi;
import com.hotent.uc.event.model.WsBusSystem;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.timeout.IdleStateEvent;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@WsServerEndpoint(value="/webSocketServer/{sysCode}/{sysSecretkey}/{sysTenantCode}")
@Component
public class WebSocketServer {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServer.class);
    private static ConcurrentMap<String, Session> sessionPool = new ConcurrentHashMap<String, Session>();
    private static ConcurrentMap<String, String> sessionIds = new ConcurrentHashMap<String, String>();
    private static final String ADMIN = "uc-service";

    @HandshakeBefore
    public void handshakeBefore(HttpHeaders headers, @PathParam String sysCode, @PathParam String sysSecretkey) {
        log.info("handshakeBefore sysCode: {}  host: {}", (Object)sysCode, (Object)headers.get("HOST"));
    }

    @OnOpen
    public void open(Session session, @PathParam String sysCode, @PathParam String sysSecretkey, @PathParam String sysTenantCode) {
        WsBusSystem busSystem = (WsBusSystem)((WsBusSystemManager)AppUtil.getBean(WsBusSystemManager.class)).getOne((Wrapper)Wrappers.lambdaQuery().eq(WsBusSystem::getSystemCode, (Object)sysCode), false);
        if (sysSecretkey.equals(busSystem.getSystemSecretKey())) {
            sessionPool.put(sysCode + "_" + sysTenantCode, session);
            sessionIds.put(session.getId(), sysCode + "_" + sysTenantCode);
            log.info("client\u3010{}\u3011\u8fde\u63a5\u6210\u529f", (Object)(sysCode + "_" + sysTenantCode));
        }
    }

    @OnMessage
    public void onMessage(Session session, String message) throws Exception {
        UcSystemEventTaskManager eventTaskManager = (UcSystemEventTaskManager)AppUtil.getBean(UcSystemEventTaskManager.class);
        JsonNode messageNode = JsonUtil.toJsonNode((String)JsonUtil.getByPath((JsonNode)JsonUtil.toJsonNode((String)message), (String)"data").asText());
        String status = "fail";
        String eventId = JsonUtil.getString((JsonNode)messageNode, (String)"eventId");
        String tenantId = JsonUtil.getString((JsonNode)messageNode, (String)"eventTenantId", (String)"-1");
        ((BaseContext)AppUtil.getBean(BaseContext.class)).setTempTenantId(tenantId);
        if ("success".toUpperCase().equals(JsonUtil.getString((JsonNode)messageNode, (String)"status"))) {
            status = "success";
            UcSystemEventTask systemEventTask = (UcSystemEventTask)eventTaskManager.getById((Serializable)((Object)eventId));
            UcSystemEventTaskHi ucSystemEventTaskHi = (UcSystemEventTaskHi)BeanUtil.copyProperties((Object)systemEventTask, UcSystemEventTaskHi.class, (String[])new String[0]);
            ucSystemEventTaskHi.setStatus(status);
            ucSystemEventTaskHi.setId(IdUtil.getSnowflakeNextIdStr());
            ((UcSystemEventTaskHiManager)AppUtil.getBean(UcSystemEventTaskHiManager.class)).save((Object)ucSystemEventTaskHi);
            eventTaskManager.remove((Serializable)((Object)eventId));
        } else {
            LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(UcSystemEventTask::getId, (Object)eventId)).set(UcSystemEventTask::getStatus, (Object)status)).setSql("RETRY_COUNT_ = RETRY_COUNT_ + 1", new Object[0]);
            eventTaskManager.update((Wrapper)updateWrapper);
        }
        log.info("client {} send to ADMIN  message : {} ", sessionIds.get(session.getId()), (Object)message);
    }

    @OnClose
    public void onClose(Session session, @PathParam String sysCode) {
        sessionPool.remove(sessionIds.get(session.getId()));
        sessionIds.remove(session.getId());
        log.info("client\u3010{}\u3011\u65ad\u5f00\u8fde\u63a5", (Object)sysCode);
    }

    @OnError
    public void onError(Session session, Throwable error) {
        error.printStackTrace();
    }

    @OnEvent
    public void onEvent(Session session, @PathParam String sysCode, Object evt) {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent idleStateEvent = (IdleStateEvent)evt;
            switch (idleStateEvent.state()) {
                case READER_IDLE: {
                    log.info("clent : {} heartbeat read timeout event", (Object)sysCode);
                    break;
                }
                case WRITER_IDLE: {
                    log.info("clent : {} heartbeat write timeout event", (Object)sysCode);
                    session.close();
                    break;
                }
                case ALL_IDLE: {
                    log.info("clent : {} heartbeat all timeout event", (Object)sysCode);
                    break;
                }
            }
        }
    }

    public void sendMessage(String message, String sysCode) {
        Session s = (Session)sessionPool.get(sysCode);
        if (s != null) {
            s.sendText(message);
        }
    }

    public static int getOnlineNum() {
        if (sessionIds.containsValue(ADMIN)) {
            return sessionPool.size() - 1;
        }
        return sessionPool.size();
    }

    public static String getOnlineUsers() {
        StringBuffer users = new StringBuffer();
        for (String key : sessionIds.keySet()) {
            if (ADMIN.equals(sessionIds.get(key))) continue;
            users.append((String)sessionIds.get(key) + ",");
        }
        return users.toString();
    }

    public void sendAll(String msg) {
        for (String key : sessionIds.keySet()) {
            if (ADMIN.equals(sessionIds.get(key))) continue;
            this.sendMessage(msg, (String)sessionIds.get(key));
        }
    }

    public synchronized void sendMany(String msg, String[] persons) {
        for (String sysCode : persons) {
            this.sendMessage(msg, sysCode);
        }
    }
}

