/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.websocket.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.core.utils.JsonUtil;
import com.hotent.uc.websocket.server.WebSocketServer;
import jakarta.annotation.Resource;
import jakarta.jms.JMSException;
import java.io.Serializable;
import org.apache.activemq.artemis.jms.client.ActiveMQObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Service;

@Service
public class WebSocketConsumer {
    Logger logger = LoggerFactory.getLogger(WebSocketConsumer.class);
    @Resource
    WebSocketServer webSocketServer;

    @JmsListener(destination="uc.event.queue", containerFactory="queueContainerFactory")
    public void receiveQueue(Object message) throws Exception {
        if (message instanceof ActiveMQObjectMessage) {
            ActiveMQObjectMessage objectMessage = (ActiveMQObjectMessage)message;
            try {
                Serializable body = objectMessage.getObject();
                this.handlerJmsMessage(body);
                this.logger.info("\u63a5\u6536\u5230artemis.test.queue\u7684\u6d88\u606f\uff1a{}", (Object)body);
            }
            catch (JMSException e) {
                this.logger.error("\u8f6c\u6362\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        } else {
            this.logger.info("\u63a5\u6536\u5230artemis.test.queue\u7684\u6d88\u606f\uff1a{}", message);
        }
    }

    private void handlerJmsMessage(Object source) throws Exception {
        JsonNode node = JsonUtil.toJsonNode((Object)source);
        JsonNode params = JsonUtil.getByPath((JsonNode)node, (String)"params");
        this.webSocketServer.sendMessage(params.asText(), JsonUtil.getString((JsonNode)node, (String)"systemCode"));
    }
}

