/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.ueditor.define;

import com.hotent.ueditor.Encoder;
import com.hotent.ueditor.define.AppInfo;
import com.hotent.ueditor.define.State;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MultiState
implements State {
    private boolean state = false;
    private String info = null;
    private Map<String, Long> intMap = new HashMap<String, Long>();
    private Map<String, String> infoMap = new HashMap<String, String>();
    private List<String> stateList = new ArrayList<String>();

    public MultiState(boolean state) {
        this.state = state;
    }

    public MultiState(boolean state, String info) {
        this.state = state;
        this.info = info;
    }

    public MultiState(boolean state, int infoKey) {
        this.state = state;
        this.info = AppInfo.getStateInfo(infoKey);
    }

    @Override
    public boolean isSuccess() {
        return this.state;
    }

    public void addState(State state) {
        this.stateList.add(state.toJSONString());
    }

    @Override
    public void putInfo(String name, String val) {
        this.infoMap.put(name, val);
    }

    @Override
    public String toJSONString() {
        String stateVal2 = this.isSuccess() ? AppInfo.getStateInfo(0) : this.info;
        StringBuilder builder = new StringBuilder();
        builder.append("{\"state\": \"" + stateVal2 + "\"");
        for (String stateVal2 : this.intMap.keySet()) {
            builder.append(",\"" + stateVal2 + "\": " + this.intMap.get(stateVal2));
        }
        for (String stateVal2 : this.infoMap.keySet()) {
            builder.append(",\"" + stateVal2 + "\": \"" + this.infoMap.get(stateVal2) + "\"");
        }
        builder.append(", list: [");
        Iterator<String> iterator = this.stateList.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next() + ",");
        }
        if (this.stateList.size() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append(" ]}");
        return Encoder.toUnicode(builder.toString());
    }

    @Override
    public void putInfo(String name, long val) {
        this.intMap.put(name, val);
    }
}

