/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions;

import com.influxdb.Arguments;
import com.influxdb.query.dsl.Flux;
import com.influxdb.query.dsl.functions.AbstractParametrizedFlux;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import javax.annotation.Nonnull;

public final class DerivativeFlux
extends AbstractParametrizedFlux {
    public DerivativeFlux(@Nonnull Flux source) {
        super(source);
    }

    @Override
    @Nonnull
    protected String operatorName() {
        return "derivative";
    }

    @Nonnull
    public DerivativeFlux withUnit(@Nonnull Long duration, @Nonnull ChronoUnit unit) {
        Arguments.checkNotNull((Object)duration, (String)"Duration is required");
        Arguments.checkNotNull((Object)unit, (String)"ChronoUnit is required");
        this.withPropertyValue("unit", duration, unit);
        return this;
    }

    @Nonnull
    public DerivativeFlux withUnit(@Nonnull String unit) {
        Arguments.checkDuration((String)unit, (String)"Unit");
        this.withPropertyValue("unit", unit);
        return this;
    }

    @Nonnull
    public DerivativeFlux withNonNegative(boolean useStartTime) {
        this.withPropertyValue("nonNegative", useStartTime);
        return this;
    }

    @Nonnull
    public DerivativeFlux withColumns(@Nonnull String[] columns) {
        Arguments.checkNotNull((Object)columns, (String)"Columns are required");
        this.withPropertyValue("columns", columns);
        return this;
    }

    @Nonnull
    public DerivativeFlux withColumns(@Nonnull Collection<String> columns) {
        Arguments.checkNotNull(columns, (String)"Columns are required");
        this.withPropertyValue("columns", columns);
        return this;
    }

    @Nonnull
    public DerivativeFlux withTimeColumn(@Nonnull String timeColumn) {
        Arguments.checkNonEmpty((String)timeColumn, (String)"Time column");
        this.withPropertyValueEscaped("timeColumn", timeColumn);
        return this;
    }
}

