/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions.properties;

import com.influxdb.Arguments;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;

public class TimeInterval {
    private Long interval;
    private ChronoUnit chronoUnit;

    public TimeInterval(@Nonnull Long interval, @Nonnull ChronoUnit chronoUnit) {
        Arguments.checkNotNull((Object)interval, (String)"Interval is required");
        Arguments.checkNotNull((Object)chronoUnit, (String)"ChronoUnit is required");
        this.interval = interval;
        this.chronoUnit = chronoUnit;
    }

    public String toString() {
        String unit;
        Long calculatedInterval = this.interval;
        switch (this.chronoUnit) {
            case NANOS: {
                unit = "ns";
                break;
            }
            case MICROS: {
                unit = "us";
                break;
            }
            case MILLIS: {
                unit = "ms";
                break;
            }
            case SECONDS: {
                unit = "s";
                break;
            }
            case MINUTES: {
                unit = "m";
                break;
            }
            case HOURS: {
                unit = "h";
                break;
            }
            case HALF_DAYS: {
                unit = "h";
                calculatedInterval = Duration.of(this.interval, ChronoUnit.HALF_DAYS).toHours();
                break;
            }
            case DAYS: {
                unit = "d";
                break;
            }
            case WEEKS: {
                unit = "w";
                break;
            }
            case MONTHS: {
                unit = "mo";
                break;
            }
            case YEARS: {
                unit = "y";
                break;
            }
            case DECADES: {
                unit = "y";
                calculatedInterval = Math.multiplyExact((long)this.interval, 10L);
                break;
            }
            case CENTURIES: {
                unit = "y";
                calculatedInterval = Math.multiplyExact((long)this.interval, 100L);
                break;
            }
            case MILLENNIA: {
                unit = "y";
                calculatedInterval = Math.multiplyExact((long)this.interval, 1000L);
                break;
            }
            case ERAS: {
                unit = "y";
                calculatedInterval = Math.multiplyExact((long)this.interval, 1000000000L);
                break;
            }
            default: {
                String message = String.format("The ChronoUnit.%s is not supported.", this.chronoUnit);
                throw new IllegalArgumentException(message);
            }
        }
        return String.valueOf(calculatedInterval) + unit;
    }
}

