/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.cert.ocsp.AbstractOCSPException;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IBasicOCSPResp;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ICertificateID;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ICertificateStatus;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IOCSPReq;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IOCSPResp;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ISingleResp;
import com.itextpdf.commons.bouncycastle.operator.AbstractOperatorCreationException;
import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.IOcspClient;
import com.itextpdf.signatures.OCSPVerifier;
import com.itextpdf.signatures.SignUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcspClientBouncyCastle
implements IOcspClient {
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(OcspClientBouncyCastle.class);
    private final OCSPVerifier verifier;

    public OcspClientBouncyCastle(OCSPVerifier verifier) {
        this.verifier = verifier;
    }

    public IBasicOCSPResp getBasicOCSPResp(X509Certificate checkCert, X509Certificate rootCert, String url) {
        try {
            IOCSPResp ocspResponse = this.getOcspResponse(checkCert, rootCert, url);
            if (ocspResponse == null) {
                return null;
            }
            if (ocspResponse.getStatus() != BOUNCY_CASTLE_FACTORY.createOCSPResponseStatus().getSuccessful()) {
                return null;
            }
            IBasicOCSPResp basicResponse = BOUNCY_CASTLE_FACTORY.createBasicOCSPResp(ocspResponse.getResponseObject());
            if (this.verifier != null) {
                this.verifier.isValidResponse(basicResponse, rootCert, DateTimeUtil.getCurrentTimeDate());
            }
            return basicResponse;
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage());
            return null;
        }
    }

    @Override
    public byte[] getEncoded(X509Certificate checkCert, X509Certificate rootCert, String url) {
        try {
            ISingleResp[] responses;
            IBasicOCSPResp basicResponse = this.getBasicOCSPResp(checkCert, rootCert, url);
            if (basicResponse != null && (responses = basicResponse.getResponses()).length == 1) {
                ISingleResp resp = responses[0];
                ICertificateStatus status = resp.getCertStatus();
                if (Objects.equals(status, BOUNCY_CASTLE_FACTORY.createCertificateStatus().getGood())) {
                    return basicResponse.getEncoded();
                }
                if (BOUNCY_CASTLE_FACTORY.createRevokedStatus(status) == null) {
                    throw new IOException("OCSP status is unknown.");
                }
                throw new IOException("OCSP status is revoked.");
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage());
        }
        return null;
    }

    private static IOCSPReq generateOCSPRequest(X509Certificate issuerCert, BigInteger serialNumber) throws AbstractOCSPException, IOException, CertificateEncodingException, AbstractOperatorCreationException {
        Security.addProvider(BOUNCY_CASTLE_FACTORY.getProvider());
        ICertificateID id = SignUtils.generateCertificateId(issuerCert, serialNumber, BOUNCY_CASTLE_FACTORY.createCertificateID().getHashSha1());
        return SignUtils.generateOcspRequestWithNonce(id);
    }

    IOCSPResp getOcspResponse(X509Certificate checkCert, X509Certificate rootCert, String url) throws GeneralSecurityException, AbstractOCSPException, IOException, AbstractOperatorCreationException {
        if (checkCert == null || rootCert == null) {
            return null;
        }
        if (url == null) {
            url = CertificateUtil.getOCSPURL(checkCert);
        }
        if (url == null) {
            return null;
        }
        LOGGER.info("Getting OCSP from " + url);
        IOCSPReq request = OcspClientBouncyCastle.generateOCSPRequest(rootCert, checkCert.getSerialNumber());
        byte[] array = request.getEncoded();
        URL urlt = new URL(url);
        InputStream in = SignUtils.getHttpResponseForOcspRequest(array, urlt);
        return BOUNCY_CASTLE_FACTORY.createOCSPResp(StreamUtil.inputStreamToArray((InputStream)in));
    }
}

