/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb;

import com.kaiwudb.util.GT;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import java.sql.DriverPropertyInfo;
import java.util.Properties;

public enum KWProperty {
    KW_DBNAME("KWDBNAME", null, "Database name to connect to (may be specified directly in the JDBC URL).", true),
    KW_HOST("KWHOST", null, "Hostname of the KaiwuDB server (may be specified directly in the JDBC URL).", false),
    KW_PORT("KWPORT", null, "Port of the KaiwuDB server (may be specified directly in the JDBC URL)."),
    USER("user", null, "Username to connect to the database as.", true),
    PASSWORD("password", null, "Password to use when authenticating.", false),
    PROTOCOL_VERSION("protocolVersion", null, "Force use of a particular protocol version when connecting, currently only version 3 is supported.", false, "3"),
    OPTIONS("options", null, "Specify 'options' connection initialization parameter."),
    LOGGER_LEVEL("loggerLevel", null, "Logger level of the driver.", false, "OFF", "DEBUG", "TRACE"),
    LOGGER_FILE("loggerFile", null, "File name output of the Logger."),
    PREPARE_THRESHOLD("prepareThreshold", "0", "Statement prepare threshold. A value of {@code -1} stands for forceBinary."),
    PREPARED_STATEMENT_CACHE_QUERIES("preparedStatementCacheQueries", "256", "Specifies the maximum number of entries in per-connection cache of prepared statements. A value of {@code 0} disables the cache."),
    PREPARED_STATEMENT_CACHE_SIZE_MIB("preparedStatementCacheSizeMiB", "5", "Specifies the maximum size (in megabytes) of a per-connection prepared statement cache. A value of {@code 0} disables the cache."),
    DATABASE_METADATA_CACHE_FIELDS("databaseMetadataCacheFields", "65536", "Specifies the maximum number of fields to be cached per connection. A value of {@code 0} disables the cache."),
    DATABASE_METADATA_CACHE_FIELDS_MIB("databaseMetadataCacheFieldsMiB", "5", "Specifies the maximum size (in megabytes) of fields to be cached per connection. A value of {@code 0} disables the cache."),
    DEFAULT_ROW_FETCH_SIZE("defaultRowFetchSize", "0", "Positive number of rows that should be fetched from the database when more rows are needed for ResultSet by each fetch iteration."),
    BINARY_TRANSFER("binaryTransfer", "true", "Use binary format for sending and receiving data if possible."),
    READ_ONLY("readOnly", "false", "Puts this connection in read-only mode."),
    BINARY_TRANSFER_ENABLE("binaryTransferEnable", "", "Comma separated list of types to enable binary transfer. Either OID numbers or names."),
    BINARY_TRANSFER_DISABLE("binaryTransferDisable", "", "Comma separated list of types to disable binary transfer. Either OID numbers or names. Overrides values in the driver default set and values set with binaryTransferEnable."),
    STRING_TYPE("stringtype", null, "The type to bind String parameters as (usually 'varchar', 'unspecified' allows implicit casting to other types).", false, "unspecified", "varchar"),
    UNKNOWN_LENGTH("unknownLength", Integer.toString(Integer.MAX_VALUE), "Specifies the length to return for types of unknown length."),
    LOG_UNCLOSED_CONNECTIONS("logUnclosedConnections", "false", "When connections that are not explicitly closed are garbage collected, log the stacktrace from the opening of the connection to trace the leak source."),
    LOG_SERVER_ERROR_DETAIL("logServerErrorDetail", "true", "Include full server error detail in exception messages. If disabled then only the error itself will be included."),
    DISABLE_COLUMN_SANITISER("disableColumnSanitiser", "false", "Enable optimization that disables column name sanitiser."),
    SSL("ssl", null, "Control use of SSL (any non-null value causes SSL to be required)."),
    SSL_MODE("sslmode", null, "Parameter governing the use of SSL.", false, "disable", "allow", "prefer", "require", "verify-ca", "verify-full"),
    SSL_FACTORY("sslfactory", null, "Provide a SSLSocketFactory class when using SSL."),
    SSL_FACTORY_ARG("sslfactoryarg", null, "Argument forwarded to constructor of SSLSocketFactory class."),
    SSL_HOSTNAME_VERIFIER("sslhostnameverifier", null, "A class, implementing javax.net.ssl.HostnameVerifier that can verify the server."),
    SSL_CERT("sslcert", null, "The location of the client's SSL certificate."),
    SSL_KEY("sslkey", null, "The location of the client's PKCS#8 SSL key."),
    SSL_SIGN_CERT("sslsigncert", null, "The location of the client's SSL signing certificate."),
    SSL_SIGN_KEY("sslsignkey", null, "The location of the client's SSL signing key."),
    SSL_MAX_PROTOCOL_VERSION("ssl_max_protocol_version", null, "The ssl protocol version for authenticating the server."),
    SSL_ROOT_CERT("sslrootcert", null, "The location of the root certificate for authenticating the server."),
    SSL_PASSWORD("sslpassword", null, "The password for the client's ssl key (ignored if sslpasswordcallback is set)."),
    SSL_PASSWORD_CALLBACK("sslpasswordcallback", null, "A class, implementing javax.security.auth.callback.CallbackHandler that can handle PassworCallback for the ssl password."),
    TCP_KEEP_ALIVE("tcpKeepAlive", "false", "Enable or disable TCP keep-alive. The default is {@code false}."),
    LOGIN_TIMEOUT("loginTimeout", "0", "Specify how long to wait for establishment of a database connection."),
    CONNECT_TIMEOUT("connectTimeout", "10", "The timeout value used for socket connect operations."),
    SOCKET_TIMEOUT("socketTimeout", "0", "The timeout value used for socket read operations."),
    CANCEL_SIGNAL_TIMEOUT("cancelSignalTimeout", "10", "The timeout that is used for sending cancel command."),
    SOCKET_FACTORY("socketFactory", null, "Specify a socket factory for socket creation."),
    SOCKET_FACTORY_ARG("socketFactoryArg", null, "Argument forwarded to constructor of SocketFactory class."),
    RECEIVE_BUFFER_SIZE("receiveBufferSize", "-1", "Socket read buffer size."),
    SEND_BUFFER_SIZE("sendBufferSize", "-1", "Socket write buffer size."),
    ASSUME_MIN_SERVER_VERSION("assumeMinServerVersion", null, "Assume the server is at least that version."),
    APPLICATION_NAME("ApplicationName", "KaiwuDB JDBC Driver", "Name of the Application (backend >= 9.0)."),
    JAAS_LOGIN("jaasLogin", "true", "Login with JAAS before doing GSSAPI authentication."),
    JAAS_APPLICATION_NAME("jaasApplicationName", null, "Specifies the name of the JAAS system or application login configuration."),
    KERBEROS_SERVER_NAME("kerberosServerName", null, "The Kerberos service name to use when authenticating with GSSAPI."),
    USE_SPNEGO("useSpnego", "false", "Use SPNEGO in SSPI authentication requests."),
    GSS_LIB("gsslib", "auto", "Force SSSPI or GSSAPI.", false, "auto", "sspi", "gssapi"),
    SSPI_SERVICE_CLASS("sspiServiceClass", "KAIWUDB", "The Windows SSPI service class for SPN."),
    ALLOW_ENCODING_CHANGES("allowEncodingChanges", "false", "Allow for changes in client_encoding."),
    CURRENT_SCHEMA("currentSchema", null, "Specify the schema (or several schema separated by commas) to be set in the search-path."),
    TARGET_SERVER_TYPE("targetServerType", "any", "Specifies what kind of server to connect.", false, "any", "master", "slave", "secondary", "preferSlave", "preferSecondary"),
    LOAD_BALANCE_HOSTS("loadBalanceHosts", "false", "If disabled hosts are connected in the given order. If enabled hosts are chosen randomly from the set of suitable candidates."),
    HOST_RECHECK_SECONDS("hostRecheckSeconds", "10", "Specifies period (seconds) after which the host status is checked again in case it has changed."),
    PREFER_QUERY_MODE("preferQueryMode", "extended", "Specifies which mode is used to execute queries to database: simple means ('Q' execute, no parse, no bind, text mode only), extended means always use bind/execute messages, extendedForPrepared means extended for prepared statements only, extendedCacheEverything means use extended protocol and try cache every statement (including Statement.execute(String sql)) in a query cache.", false, "extended", "extendedForPrepared", "extendedCacheEverything", "simple"),
    AUTOSAVE("autosave", "never", "Specifies what the driver should do if a query fails. In autosave=always mode, JDBC driver sets a savepoint before each query, and rolls back to that savepoint in case of failure. In autosave=never mode (default), no savepoint dance is made ever. In autosave=conservative mode, safepoint is set for each query, however the rollback is done only for rare cases like 'cached statement cannot change return type' or 'statement XXX is not valid' so JDBC driver rollsback and retries.", false, "always", "never", "conservative"),
    CLEANUP_SAVEPOINTS("cleanupSavepoints", "false", "Determine whether SAVEPOINTS used in AUTOSAVE will be released per query or not.", false, "true", "false"),
    REWRITE_BATCHED_INSERTS("reWriteBatchedInserts", "false", "Enable optimization to rewrite and collapse compatible INSERT statements that are batched."),
    HIDE_UNPRIVILEGED_OBJECTS("hideUnprivilegedObjects", "false", "Enable hiding of database objects for which the current user has no privileges granted from the DatabaseMetaData."),
    REPLICATION("replication", null, "Connection parameter passed in startup message, one of 'true' or 'database' Passing 'true' tells the backend to go into walsender mode, wherein a small set of replication commands can be issued instead of SQL statements. Only the simple query protocol can be used in walsender mode. Passing 'database' as the value instructs walsender to connect to the database specified in the dbname parameter, which will allow the connection to be used for logical replication from that database. (backend >= 9.4)."),
    ESCAPE_SYNTAX_CALL_MODE("escapeSyntaxCallMode", "select", "Specifies how the driver transforms JDBC escape call syntax into underlying SQL, for invoking procedures or functions. (backend >= 11)In escapeSyntaxCallMode=select mode (the default), the driver always uses a SELECT statement (allowing function invocation only).In escapeSyntaxCallMode=callIfNoReturn mode, the driver uses a CALL statement (allowing procedure invocation) if there is no return parameter specified, otherwise the driver uses a SELECT statement.In escapeSyntaxCallMode=call mode, the driver always uses a CALL statement (allowing procedure invocation only).", false, "select", "callIfNoReturn", "call"),
    READ_ONLY_MODE("readOnlyMode", "transaction", "Controls the behavior when a connection is set to be read only, one of 'ignore', 'transaction', or 'always' When 'ignore', setting readOnly has no effect. When 'transaction' setting readOnly to 'true' will cause transactions to BEGIN READ ONLY if autocommit is 'false'. When 'always' setting readOnly to 'true' will set the session to READ ONLY if autoCommit is 'true' and the transaction to BEGIN READ ONLY if autocommit is 'false'.", false, "ignore", "transaction", "always");

    private final String name;
    private final String defaultValue;
    private final boolean required;
    private final String description;
    private final String[] choices;

    private KWProperty(String name, String defaultValue, String description) {
        this(name, defaultValue, description, false);
    }

    private KWProperty(String name, String defaultValue, String description, boolean required) {
        this(name, defaultValue, description, required, null);
    }

    private KWProperty(String name, String defaultValue, String description, boolean required, String ... choices) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.required = required;
        this.description = description;
        this.choices = choices;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public String get(Properties properties) {
        return properties.getProperty(this.name, this.defaultValue);
    }

    public void set(Properties properties, String value) {
        if (value == null) {
            properties.remove(this.name);
        } else {
            properties.setProperty(this.name, value);
        }
    }

    public boolean getBoolean(Properties properties) {
        return Boolean.valueOf(this.get(properties));
    }

    public int getIntNoCheck(Properties properties) {
        String value = this.get(properties);
        return Integer.parseInt(value);
    }

    public int getInt(Properties properties) throws KSQLException {
        String value = this.get(properties);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new KSQLException(GT.tr("{0} parameter value must be an integer but was: {1}", this.getName(), value), KSQLState.INVALID_PARAMETER_VALUE, (Throwable)nfe);
        }
    }

    public Integer getInteger(Properties properties) throws KSQLException {
        String value = this.get(properties);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new KSQLException(GT.tr("{0} parameter value must be an integer but was: {1}", this.getName(), value), KSQLState.INVALID_PARAMETER_VALUE, (Throwable)nfe);
        }
    }

    public void set(Properties properties, boolean value) {
        properties.setProperty(this.name, Boolean.toString(value));
    }

    public void set(Properties properties, int value) {
        properties.setProperty(this.name, Integer.toString(value));
    }

    public boolean isPresent(Properties properties) {
        return this.getSetString(properties) != null;
    }

    public DriverPropertyInfo toDriverPropertyInfo(Properties properties) {
        DriverPropertyInfo propertyInfo = new DriverPropertyInfo(this.name, this.get(properties));
        propertyInfo.required = this.required;
        propertyInfo.description = this.description;
        propertyInfo.choices = this.choices;
        return propertyInfo;
    }

    public static KWProperty forName(String name) {
        for (KWProperty property : KWProperty.values()) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public String getSetString(Properties properties) {
        Object o = properties.get(this.name);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }
}

