/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.core;

import com.kaiwudb.KWProperty;
import com.kaiwudb.core.KWStream;
import com.kaiwudb.core.QueryExecutor;
import com.kaiwudb.core.v3.ConnectionFactoryImpl;
import com.kaiwudb.util.GT;
import com.kaiwudb.util.HostSpec;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;

public abstract class ConnectionFactory {
    public static QueryExecutor openConnection(HostSpec[] hostSpecs, String user, String database, Properties info) throws SQLException {
        ConnectionFactoryImpl connectionFactory;
        QueryExecutor queryExecutor;
        String protoName = KWProperty.PROTOCOL_VERSION.get(info);
        if ((protoName == null || protoName.isEmpty() || "3".equals(protoName)) && (queryExecutor = ((ConnectionFactory)(connectionFactory = new ConnectionFactoryImpl())).openConnectionImpl(hostSpecs, user, database, info)) != null) {
            return queryExecutor;
        }
        throw new KSQLException(GT.tr("A connection could not be made using the requested protocol {0}.", protoName), KSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    public abstract QueryExecutor openConnectionImpl(HostSpec[] var1, String var2, String var3, Properties var4) throws SQLException;

    protected void closeStream(KWStream newStream) {
        if (newStream != null) {
            try {
                newStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

