/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.core;

import com.kaiwudb.core.Encoding;
import com.kaiwudb.core.EncodingPredictor;
import com.kaiwudb.core.KWBindException;
import com.kaiwudb.core.VisibleBufferedInputStream;
import com.kaiwudb.util.GT;
import com.kaiwudb.util.HostSpec;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import javax.net.SocketFactory;

public class KWStream
implements Closeable,
Flushable {
    private final SocketFactory socketFactory;
    private final HostSpec hostSpec;
    private final byte[] int4Buf;
    private final byte[] int2Buf;
    private Socket connection;
    private VisibleBufferedInputStream kwInput;
    private OutputStream kwOutput;
    private byte[] streamBuffer;
    private long nextStreamAvailableCheckTime;
    private int minStreamAvailableCheckDelay = 1000;
    private Encoding encoding;
    private Writer encodingWriter;

    public KWStream(SocketFactory socketFactory, HostSpec hostSpec, int timeout) throws IOException {
        this.socketFactory = socketFactory;
        this.hostSpec = hostSpec;
        Socket socket = socketFactory.createSocket();
        if (!socket.isConnected()) {
            InetSocketAddress address = hostSpec.shouldResolve() != false ? new InetSocketAddress(hostSpec.getHost(), hostSpec.getPort()) : InetSocketAddress.createUnresolved(hostSpec.getHost(), hostSpec.getPort());
            socket.connect(address, timeout);
        }
        this.changeSocket(socket);
        this.setEncoding(Encoding.getJVMEncoding("UTF-8"));
        this.int2Buf = new byte[2];
        this.int4Buf = new byte[4];
    }

    @Deprecated
    public KWStream(SocketFactory socketFactory, HostSpec hostSpec) throws IOException {
        this(socketFactory, hostSpec, 0);
    }

    public HostSpec getHostSpec() {
        return this.hostSpec;
    }

    public Socket getSocket() {
        return this.connection;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessagePending() throws IOException {
        boolean available = false;
        if (this.kwInput.available() > 0) {
            return true;
        }
        long now = System.nanoTime() / 1000000L;
        if (now < this.nextStreamAvailableCheckTime && this.minStreamAvailableCheckDelay != 0) {
            return false;
        }
        int soTimeout = this.getNetworkTimeout();
        this.setNetworkTimeout(1);
        try {
            available = this.kwInput.peek() != -1;
        }
        catch (SocketTimeoutException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.setNetworkTimeout(soTimeout);
        }
        if (!available) {
            this.nextStreamAvailableCheckTime = now + (long)this.minStreamAvailableCheckDelay;
        }
        return available;
    }

    public void setMinStreamAvailableCheckDelay(int delay) {
        this.minStreamAvailableCheckDelay = delay;
    }

    public void changeSocket(Socket socket) throws IOException {
        this.connection = socket;
        this.connection.setTcpNoDelay(true);
        this.kwInput = new VisibleBufferedInputStream(this.connection.getInputStream(), 8192);
        this.kwOutput = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
        if (this.encoding != null) {
            this.setEncoding(this.encoding);
        }
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) throws IOException {
        if (this.encoding != null && this.encoding.name().equals(encoding.name())) {
            return;
        }
        if (this.encodingWriter != null) {
            this.encodingWriter.close();
        }
        this.encoding = encoding;
        FilterOutputStream interceptor = new FilterOutputStream(this.kwOutput){

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                super.flush();
            }
        };
        this.encodingWriter = encoding.getEncodingWriter(interceptor);
    }

    public Writer getEncodingWriter() throws IOException {
        if (this.encodingWriter == null) {
            throw new IOException("No encoding has been set on this connection");
        }
        return this.encodingWriter;
    }

    public void sendChar(int val) throws IOException {
        this.kwOutput.write(val);
    }

    public void sendInteger4(int val) throws IOException {
        this.int4Buf[0] = (byte)(val >>> 24);
        this.int4Buf[1] = (byte)(val >>> 16);
        this.int4Buf[2] = (byte)(val >>> 8);
        this.int4Buf[3] = (byte)val;
        this.kwOutput.write(this.int4Buf);
    }

    public void sendInteger2(int val) throws IOException {
        if (val < Short.MIN_VALUE || val > Short.MAX_VALUE) {
            throw new IOException("Tried to send an out-of-range integer as a 2-byte value: " + val);
        }
        this.int2Buf[0] = (byte)(val >>> 8);
        this.int2Buf[1] = (byte)val;
        this.kwOutput.write(this.int2Buf);
    }

    public void send(byte[] buf) throws IOException {
        this.kwOutput.write(buf);
    }

    public void send(byte[] buf, int siz) throws IOException {
        this.send(buf, 0, siz);
    }

    public void send(byte[] buf, int off, int siz) throws IOException {
        int bufamt = buf.length - off;
        this.kwOutput.write(buf, off, bufamt < siz ? bufamt : siz);
        for (int i = bufamt; i < siz; ++i) {
            this.kwOutput.write(0);
        }
    }

    public int peekChar() throws IOException {
        int c = this.kwInput.peek();
        if (c < 0) {
            throw new EOFException();
        }
        return c;
    }

    public int receiveChar() throws IOException {
        int c = this.kwInput.read();
        if (c < 0) {
            throw new EOFException();
        }
        return c;
    }

    public int receiveInteger4() throws IOException {
        if (this.kwInput.read(this.int4Buf) != 4) {
            throw new EOFException();
        }
        return (this.int4Buf[0] & 0xFF) << 24 | (this.int4Buf[1] & 0xFF) << 16 | (this.int4Buf[2] & 0xFF) << 8 | this.int4Buf[3] & 0xFF;
    }

    public int receiveInteger2() throws IOException {
        if (this.kwInput.read(this.int2Buf) != 2) {
            throw new EOFException();
        }
        return (this.int2Buf[0] & 0xFF) << 8 | this.int2Buf[1] & 0xFF;
    }

    public String receiveString(int len) throws IOException {
        if (!this.kwInput.ensureBytes(len)) {
            throw new EOFException();
        }
        String res = this.encoding.decode(this.kwInput.getBuffer(), this.kwInput.getIndex(), len);
        this.kwInput.skip(len);
        return res;
    }

    public EncodingPredictor.DecodeResult receiveErrorString(int len) throws IOException {
        EncodingPredictor.DecodeResult res;
        block3: {
            if (!this.kwInput.ensureBytes(len)) {
                throw new EOFException();
            }
            try {
                String value = this.encoding.decode(this.kwInput.getBuffer(), this.kwInput.getIndex(), len);
                res = new EncodingPredictor.DecodeResult(value, null);
            }
            catch (IOException e) {
                res = EncodingPredictor.decode(this.kwInput.getBuffer(), this.kwInput.getIndex(), len);
                if (res != null) break block3;
                Encoding enc = Encoding.defaultEncoding();
                String value = enc.decode(this.kwInput.getBuffer(), this.kwInput.getIndex(), len);
                res = new EncodingPredictor.DecodeResult(value, enc.name());
            }
        }
        this.kwInput.skip(len);
        return res;
    }

    public String receiveString() throws IOException {
        int len = this.kwInput.scanCStringLength();
        String res = this.encoding.decode(this.kwInput.getBuffer(), this.kwInput.getIndex(), len - 1);
        this.kwInput.skip(len);
        return res;
    }

    public byte[][] receiveTupleV3() throws IOException, OutOfMemoryError {
        this.receiveInteger4();
        int nf = this.receiveInteger2();
        byte[][] answer = new byte[nf][];
        OutOfMemoryError oom = null;
        for (int i = 0; i < nf; ++i) {
            int size = this.receiveInteger4();
            if (size == -1) continue;
            try {
                answer[i] = new byte[size];
                this.receive(answer[i], 0, size);
                continue;
            }
            catch (OutOfMemoryError oome) {
                oom = oome;
                this.skip(size);
            }
        }
        if (oom != null) {
            throw oom;
        }
        return answer;
    }

    public byte[] receive(int siz) throws IOException {
        byte[] answer = new byte[siz];
        this.receive(answer, 0, siz);
        return answer;
    }

    public void receive(byte[] buf, int off, int siz) throws IOException {
        int w;
        for (int s = 0; s < siz; s += w) {
            w = this.kwInput.read(buf, off + s, siz - s);
            if (w >= 0) continue;
            throw new EOFException();
        }
    }

    public void skip(int size) throws IOException {
        for (long s = 0L; s < (long)size; s += this.kwInput.skip((long)size - s)) {
        }
    }

    public void sendStream(InputStream inStream, int remaining) throws IOException {
        int expectedLength = remaining;
        if (this.streamBuffer == null) {
            this.streamBuffer = new byte[8192];
        }
        while (remaining > 0) {
            int readCount;
            int count = remaining > this.streamBuffer.length ? this.streamBuffer.length : remaining;
            try {
                readCount = inStream.read(this.streamBuffer, 0, count);
                if (readCount < 0) {
                    throw new EOFException(GT.tr("Premature end of input stream, expected {0} bytes, but only read {1}.", expectedLength, expectedLength - remaining));
                }
            }
            catch (IOException ioe) {
                while (remaining > 0) {
                    this.send(this.streamBuffer, count);
                    count = (remaining -= count) > this.streamBuffer.length ? this.streamBuffer.length : remaining;
                }
                throw new KWBindException(ioe);
            }
            this.send(this.streamBuffer, readCount);
            remaining -= readCount;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.encodingWriter != null) {
            this.encodingWriter.flush();
        }
        this.kwOutput.flush();
    }

    public void receiveEOF() throws SQLException, IOException {
        int c = this.kwInput.read();
        if (c < 0) {
            return;
        }
        throw new KSQLException(GT.tr("Expected an EOF from server, got: {0}", c), KSQLState.COMMUNICATION_ERROR);
    }

    @Override
    public void close() throws IOException {
        if (this.encodingWriter != null) {
            this.encodingWriter.close();
        }
        this.kwOutput.close();
        this.kwInput.close();
        this.connection.close();
    }

    public void setNetworkTimeout(int milliseconds) throws IOException {
        this.connection.setSoTimeout(milliseconds);
    }

    public int getNetworkTimeout() throws IOException {
        return this.connection.getSoTimeout();
    }
}

