/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.core.v3;

import com.kaiwudb.KWProperty;
import com.kaiwudb.core.ConnectionFactory;
import com.kaiwudb.core.KWStream;
import com.kaiwudb.core.QueryExecutor;
import com.kaiwudb.core.ServerVersion;
import com.kaiwudb.core.SetupQueryRunner;
import com.kaiwudb.core.SocketFactoryFactory;
import com.kaiwudb.core.Utils;
import com.kaiwudb.core.Version;
import com.kaiwudb.core.v3.QueryExecutorImpl;
import com.kaiwudb.gss.MakeGSS;
import com.kaiwudb.hostchooser.CandidateHost;
import com.kaiwudb.hostchooser.GlobalHostStatusTracker;
import com.kaiwudb.hostchooser.HostChooser;
import com.kaiwudb.hostchooser.HostChooserFactory;
import com.kaiwudb.hostchooser.HostRequirement;
import com.kaiwudb.hostchooser.HostStatus;
import com.kaiwudb.jdbc.SslMode;
import com.kaiwudb.jre7.sasl.ScramAuthenticator;
import com.kaiwudb.ssl.MakeSSL;
import com.kaiwudb.sspi.ISSPIClient;
import com.kaiwudb.util.GT;
import com.kaiwudb.util.HostSpec;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import com.kaiwudb.util.MD5Digest;
import com.kaiwudb.util.ServerErrorMessage;
import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.net.SocketFactory;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger(ConnectionFactoryImpl.class.getName());
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;
    private static final int AUTH_REQ_GSS = 7;
    private static final int AUTH_REQ_GSS_CONTINUE = 8;
    private static final int AUTH_REQ_SSPI = 9;
    private static final int AUTH_REQ_SASL = 10;
    private static final int AUTH_REQ_SASL_CONTINUE = 11;
    private static final int AUTH_REQ_SASL_FINAL = 12;

    private ISSPIClient createSSPI(KWStream kwStream, String spnServiceClass, boolean enableNegotiate) {
        try {
            Class<?> c = Class.forName("com.kaiwudb.sspi.SSPIClient");
            return (ISSPIClient)c.getDeclaredConstructor(KWStream.class, String.class, Boolean.TYPE).newInstance(kwStream, spnServiceClass, enableNegotiate);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to load SSPIClient. Please check that SSPIClient is included in your kwjdbc distribution.", e);
        }
    }

    private KWStream tryConnect(String user, String database, Properties info, SocketFactory socketFactory, HostSpec hostSpec, SslMode sslMode) throws SQLException, IOException {
        int sendBufferSize;
        int connectTimeout = KWProperty.CONNECT_TIMEOUT.getInt(info) * 1000;
        KWStream newStream = new KWStream(socketFactory, hostSpec, connectTimeout);
        int socketTimeout = KWProperty.SOCKET_TIMEOUT.getInt(info);
        if (socketTimeout > 0) {
            newStream.getSocket().setSoTimeout(socketTimeout * 1000);
        }
        boolean requireTCPKeepAlive = KWProperty.TCP_KEEP_ALIVE.getBoolean(info);
        newStream.getSocket().setKeepAlive(requireTCPKeepAlive);
        int receiveBufferSize = KWProperty.RECEIVE_BUFFER_SIZE.getInt(info);
        if (receiveBufferSize > -1) {
            if (receiveBufferSize > 0) {
                newStream.getSocket().setReceiveBufferSize(receiveBufferSize);
            } else {
                LOGGER.log(Level.WARNING, "Ignore invalid value for receiveBufferSize: {0}", receiveBufferSize);
            }
        }
        if ((sendBufferSize = KWProperty.SEND_BUFFER_SIZE.getInt(info)) > -1) {
            if (sendBufferSize > 0) {
                newStream.getSocket().setSendBufferSize(sendBufferSize);
            } else {
                LOGGER.log(Level.WARNING, "Ignore invalid value for sendBufferSize: {0}", sendBufferSize);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Receive Buffer Size is {0}", newStream.getSocket().getReceiveBufferSize());
            LOGGER.log(Level.FINE, "Send Buffer Size is {0}", newStream.getSocket().getSendBufferSize());
        }
        newStream = this.enableSSL(newStream, sslMode, info, connectTimeout);
        List<String[]> paramList = this.getParametersForStartup(user, database, info);
        this.sendStartupPacket(newStream, paramList);
        this.doAuthentication(newStream, hostSpec.getHost(), user, info);
        return newStream;
    }

    @Override
    public QueryExecutor openConnectionImpl(HostSpec[] hostSpecs, String user, String database, Properties info) throws SQLException {
        HostRequirement targetServerType;
        SslMode sslMode = SslMode.of(info);
        String targetServerTypeStr = KWProperty.TARGET_SERVER_TYPE.get(info);
        try {
            targetServerType = HostRequirement.getTargetServerType(targetServerTypeStr);
        }
        catch (IllegalArgumentException ex) {
            throw new KSQLException(GT.tr("Invalid targetServerType value: {0}", targetServerTypeStr), KSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        SocketFactory socketFactory = SocketFactoryFactory.getSocketFactory(info);
        HostChooser hostChooser = HostChooserFactory.createHostChooser(hostSpecs, targetServerType, info);
        Iterator<CandidateHost> hostIter = hostChooser.iterator();
        HashMap<HostSpec, HostStatus> knownStates = new HashMap<HostSpec, HostStatus>();
        while (hostIter.hasNext()) {
            CandidateHost candidateHost = hostIter.next();
            HostSpec hostSpec = candidateHost.hostSpec;
            LOGGER.log(Level.FINE, "Trying to establish a protocol version 3 connection to {0}", hostSpec);
            HostStatus knownStatus = (HostStatus)((Object)knownStates.get(hostSpec));
            if (knownStatus != null && !candidateHost.targetServerType.allowConnectingTo(knownStatus)) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.log(Level.FINER, "Known status of host {0} is {1}, and required status was {2}. Will try next host", new Object[]{hostSpec, knownStatus, candidateHost.targetServerType});
                continue;
            }
            KWStream newStream = null;
            try {
                try {
                    newStream = this.tryConnect(user, database, info, socketFactory, hostSpec, sslMode);
                }
                catch (SQLException e) {
                    Exception ex;
                    if (sslMode == SslMode.PREFER && KSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(e.getSQLState())) {
                        ex = null;
                        try {
                            newStream = this.tryConnect(user, database, info, socketFactory, hostSpec, SslMode.DISABLE);
                            LOGGER.log(Level.FINE, "Downgraded to non-encrypted connection for host {0}", hostSpec);
                        }
                        catch (SQLException ee) {
                            ex = ee;
                        }
                        catch (IOException ee) {
                            ex = ee;
                        }
                        if (ex != null) {
                            ConnectionFactoryImpl.log(Level.FINE, "sslMode==PREFER, however non-SSL connection failed as well", ex, new Object[0]);
                            e.addSuppressed(ex);
                            throw e;
                        }
                    }
                    if (sslMode == SslMode.ALLOW && KSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(e.getSQLState())) {
                        ex = null;
                        try {
                            newStream = this.tryConnect(user, database, info, socketFactory, hostSpec, SslMode.REQUIRE);
                            LOGGER.log(Level.FINE, "Upgraded to encrypted connection for host {0}", hostSpec);
                        }
                        catch (SQLException ee) {
                            ex = ee;
                        }
                        catch (IOException ee) {
                            ex = ee;
                        }
                        if (ex != null) {
                            ConnectionFactoryImpl.log(Level.FINE, "sslMode==ALLOW, however SSL connection failed as well", ex, new Object[0]);
                            e.addSuppressed(ex);
                            throw e;
                        }
                    }
                    throw e;
                }
                int cancelSignalTimeout = KWProperty.CANCEL_SIGNAL_TIMEOUT.getInt(info) * 1000;
                QueryExecutorImpl queryExecutor = new QueryExecutorImpl(newStream, user, database, cancelSignalTimeout, info);
                HostStatus hostStatus = HostStatus.ConnectOK;
                if (candidateHost.targetServerType != HostRequirement.any) {
                    hostStatus = this.isMaster(queryExecutor) ? HostStatus.Master : HostStatus.Secondary;
                }
                GlobalHostStatusTracker.reportHostStatus(hostSpec, hostStatus);
                knownStates.put(hostSpec, hostStatus);
                if (!candidateHost.targetServerType.allowConnectingTo(hostStatus)) {
                    queryExecutor.close();
                    continue;
                }
                this.runInitialQueries(queryExecutor, info);
                return queryExecutor;
            }
            catch (ConnectException cex) {
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) {
                    ConnectionFactoryImpl.log(Level.FINE, "ConnectException occurred while connecting to {0}", cex, hostSpec);
                    continue;
                }
                throw new KSQLException(GT.tr("Connection to {0} refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections.", hostSpec), KSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)cex);
            }
            catch (IOException ioe) {
                this.closeStream(newStream);
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) {
                    ConnectionFactoryImpl.log(Level.FINE, "IOException occurred while connecting to {0}", ioe, hostSpec);
                    continue;
                }
                throw new KSQLException(GT.tr("The connection attempt failed.", new Object[0]), KSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
            }
            catch (SQLException se) {
                this.closeStream(newStream);
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) {
                    ConnectionFactoryImpl.log(Level.FINE, "SQLException occurred while connecting to {0}", se, hostSpec);
                    continue;
                }
                throw se;
            }
        }
        throw new KSQLException(GT.tr("Could not find a server with specified targetServerType: {0}", new Object[]{targetServerType}), KSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private List<String[]> getParametersForStartup(String user, String database, Properties info) {
        String options;
        String currentSchema;
        ArrayList<String[]> paramList = new ArrayList<String[]>();
        paramList.add(new String[]{"user", user});
        paramList.add(new String[]{"database", database});
        paramList.add(new String[]{"client_encoding", "UTF8"});
        paramList.add(new String[]{"DateStyle", "ISO"});
        paramList.add(new String[]{"TimeZone", ConnectionFactoryImpl.createKaiwuDBTimeZone()});
        Version assumeVersion = ServerVersion.from(KWProperty.ASSUME_MIN_SERVER_VERSION.get(info));
        if (assumeVersion.getVersionNum() >= ServerVersion.v9_0.getVersionNum()) {
            paramList.add(new String[]{"extra_float_digits", "3"});
            String appName = KWProperty.APPLICATION_NAME.get(info);
            if (appName != null) {
                paramList.add(new String[]{"application_name", appName});
            }
        } else {
            paramList.add(new String[]{"extra_float_digits", "2"});
        }
        String replication = KWProperty.REPLICATION.get(info);
        if (replication != null && assumeVersion.getVersionNum() >= ServerVersion.v9_4.getVersionNum()) {
            paramList.add(new String[]{"replication", replication});
        }
        if ((currentSchema = KWProperty.CURRENT_SCHEMA.get(info)) != null) {
            paramList.add(new String[]{"search_path", currentSchema});
        }
        if ((options = KWProperty.OPTIONS.get(info)) != null) {
            paramList.add(new String[]{"options", options});
        }
        return paramList;
    }

    private static void log(Level level, String msg, Throwable thrown, Object ... params) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        LogRecord rec = new LogRecord(level, msg);
        rec.setLoggerName(LOGGER.getName());
        rec.setParameters(params);
        rec.setThrown(thrown);
        LOGGER.log(rec);
    }

    private static String createKaiwuDBTimeZone() {
        String start;
        String tz = TimeZone.getDefault().getID();
        if (tz.length() <= 3 || !tz.startsWith("GMT")) {
            return tz;
        }
        char sign = tz.charAt(3);
        switch (sign) {
            case '+': {
                start = "GMT-";
                break;
            }
            case '-': {
                start = "GMT+";
                break;
            }
            default: {
                return tz;
            }
        }
        return start + tz.substring(4);
    }

    private KWStream enableSSL(KWStream kwStream, SslMode sslMode, Properties info, int connectTimeout) throws IOException, KSQLException {
        if (sslMode == SslMode.DISABLE) {
            return kwStream;
        }
        if (sslMode == SslMode.ALLOW) {
            return kwStream;
        }
        LOGGER.log(Level.FINEST, " FE=> SSLRequest");
        kwStream.sendInteger4(8);
        kwStream.sendInteger2(1234);
        kwStream.sendInteger2(5679);
        kwStream.flush();
        int beresp = kwStream.receiveChar();
        switch (beresp) {
            case 69: {
                LOGGER.log(Level.FINEST, " <=BE SSLError");
                if (sslMode.requireEncryption()) {
                    throw new KSQLException(GT.tr("The server does not support SSL.", new Object[0]), KSQLState.CONNECTION_REJECTED);
                }
                kwStream.close();
                return new KWStream(kwStream.getSocketFactory(), kwStream.getHostSpec(), connectTimeout);
            }
            case 78: {
                LOGGER.log(Level.FINEST, " <=BE SSLRefused");
                if (sslMode.requireEncryption()) {
                    throw new KSQLException(GT.tr("The server does not support SSL.", new Object[0]), KSQLState.CONNECTION_REJECTED);
                }
                return kwStream;
            }
            case 83: {
                LOGGER.log(Level.FINEST, " <=BE SSLOk");
                MakeSSL.convert(kwStream, info);
                return kwStream;
            }
        }
        throw new KSQLException(GT.tr("An error occurred while setting up the SSL connection.", new Object[0]), KSQLState.PROTOCOL_VIOLATION);
    }

    private void sendStartupPacket(KWStream kwStream, List<String[]> params) throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder details = new StringBuilder();
            for (int i = 0; i < params.size(); ++i) {
                if (i != 0) {
                    details.append(", ");
                }
                details.append(params.get(i)[0]);
                details.append("=");
                details.append(params.get(i)[1]);
            }
            LOGGER.log(Level.FINEST, " FE=> StartupPacket({0})", details);
        }
        int length = 8;
        byte[][] encodedParams = new byte[params.size() * 2][];
        for (int i = 0; i < params.size(); ++i) {
            encodedParams[i * 2] = params.get(i)[0].getBytes("UTF-8");
            encodedParams[i * 2 + 1] = params.get(i)[1].getBytes("UTF-8");
            length += encodedParams[i * 2].length + 1 + encodedParams[i * 2 + 1].length + 1;
        }
        kwStream.sendInteger4(++length);
        kwStream.sendInteger2(3);
        kwStream.sendInteger2(0);
        for (byte[] encodedParam : encodedParams) {
            kwStream.send(encodedParam);
            kwStream.sendChar(0);
        }
        kwStream.sendChar(0);
        kwStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAuthentication(KWStream kwStream, String host, String user, Properties info) throws IOException, SQLException {
        block35: {
            String password = KWProperty.PASSWORD.get(info);
            ISSPIClient sspiClient = null;
            ScramAuthenticator scramAuthenticator = null;
            try {
                while (true) {
                    int beresp = kwStream.receiveChar();
                    block3 : switch (beresp) {
                        case 69: {
                            int elen = kwStream.receiveInteger4();
                            ServerErrorMessage errorMsg = new ServerErrorMessage(kwStream.receiveErrorString(elen - 4));
                            LOGGER.log(Level.FINEST, " <=BE ErrorMessage({0})", errorMsg);
                            throw new KSQLException(errorMsg, KWProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                        }
                        case 82: {
                            int msgLen = kwStream.receiveInteger4();
                            int areq = kwStream.receiveInteger4();
                            switch (areq) {
                                case 5: {
                                    byte[] md5Salt = kwStream.receive(4);
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        LOGGER.log(Level.FINEST, " <=BE AuthenticationReqMD5(salt={0})", Utils.toHexString(md5Salt));
                                    }
                                    if (password == null) {
                                        throw new KSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), KSQLState.CONNECTION_REJECTED);
                                    }
                                    byte[] digest = MD5Digest.encode(user.getBytes("UTF-8"), password.getBytes("UTF-8"), md5Salt);
                                    if (LOGGER.isLoggable(Level.FINEST)) {
                                        LOGGER.log(Level.FINEST, " FE=> Password(md5digest={0})", new String(digest, "US-ASCII"));
                                    }
                                    kwStream.sendChar(112);
                                    kwStream.sendInteger4(4 + digest.length + 1);
                                    kwStream.send(digest);
                                    kwStream.sendChar(0);
                                    kwStream.flush();
                                    break block3;
                                }
                                case 3: {
                                    LOGGER.log(Level.FINEST, "<=BE AuthenticationReqPassword");
                                    LOGGER.log(Level.FINEST, " FE=> Password(password=<not shown>)");
                                    if (password == null) {
                                        throw new KSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), KSQLState.CONNECTION_REJECTED);
                                    }
                                    byte[] encodedPassword = password.getBytes("UTF-8");
                                    kwStream.sendChar(112);
                                    kwStream.sendInteger4(4 + encodedPassword.length + 1);
                                    kwStream.send(encodedPassword);
                                    kwStream.sendChar(0);
                                    kwStream.flush();
                                    break block3;
                                }
                                case 7: 
                                case 9: {
                                    String gsslib = KWProperty.GSS_LIB.get(info);
                                    boolean usespnego = KWProperty.USE_SPNEGO.getBoolean(info);
                                    boolean useSSPI = false;
                                    if (gsslib.equals("gssapi")) {
                                        LOGGER.log(Level.FINE, "Using JSSE GSSAPI, param gsslib=gssapi");
                                    } else if (areq == 7 && !gsslib.equals("sspi")) {
                                        LOGGER.log(Level.FINE, "Using JSSE GSSAPI, gssapi requested by server and gsslib=sspi not forced");
                                    } else {
                                        sspiClient = this.createSSPI(kwStream, KWProperty.SSPI_SERVICE_CLASS.get(info), areq == 9 || areq == 7 && usespnego);
                                        useSSPI = sspiClient.isSSPISupported();
                                        LOGGER.log(Level.FINE, "SSPI support detected: {0}", useSSPI);
                                        if (!useSSPI) {
                                            sspiClient = null;
                                            if (gsslib.equals("sspi")) {
                                                throw new KSQLException("SSPI forced with gsslib=sspi, but SSPI not available; set loglevel=2 for details", KSQLState.CONNECTION_UNABLE_TO_CONNECT);
                                            }
                                        }
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.log(Level.FINE, "Using SSPI: {0}, gsslib={1} and SSPI support detected", new Object[]{useSSPI, gsslib});
                                        }
                                    }
                                    if (useSSPI) {
                                        sspiClient.startSSPI();
                                        break block3;
                                    }
                                    MakeGSS.authenticate(kwStream, host, user, password, KWProperty.JAAS_APPLICATION_NAME.get(info), KWProperty.KERBEROS_SERVER_NAME.get(info), usespnego, KWProperty.JAAS_LOGIN.getBoolean(info), KWProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(info));
                                    break block3;
                                }
                                case 8: {
                                    sspiClient.continueSSPI(msgLen - 8);
                                    break block3;
                                }
                                case 10: {
                                    LOGGER.log(Level.FINEST, " <=BE AuthenticationSASL");
                                    scramAuthenticator = new ScramAuthenticator(user, password, kwStream);
                                    scramAuthenticator.processServerMechanismsAndInit();
                                    scramAuthenticator.sendScramClientFirstMessage();
                                    break block3;
                                }
                                case 11: {
                                    scramAuthenticator.processServerFirstMessage(msgLen - 4 - 4);
                                    break block3;
                                }
                                case 12: {
                                    scramAuthenticator.verifyServerSignature(msgLen - 4 - 4);
                                    break block3;
                                }
                                case 0: {
                                    LOGGER.log(Level.FINEST, " <=BE AuthenticationOk");
                                    break block35;
                                }
                                default: {
                                    LOGGER.log(Level.FINEST, " <=BE AuthenticationReq (unsupported type {0})", areq);
                                    throw new KSQLException(GT.tr("The authentication type {0} is not supported. Check that you have configured the kw_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", areq), KSQLState.CONNECTION_REJECTED);
                                }
                            }
                        }
                        default: {
                            throw new KSQLException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), KSQLState.PROTOCOL_VIOLATION);
                        }
                    }
                }
            }
            finally {
                if (sspiClient != null) {
                    try {
                        sspiClient.dispose();
                    }
                    catch (RuntimeException ex) {
                        LOGGER.log(Level.FINE, "Unexpected error during SSPI context disposal", ex);
                    }
                }
            }
        }
    }

    private void runInitialQueries(QueryExecutor queryExecutor, Properties info) throws SQLException {
        String appName;
        String assumeMinServerVersion = KWProperty.ASSUME_MIN_SERVER_VERSION.get(info);
        if (Utils.parseServerVersionStr(assumeMinServerVersion) >= ServerVersion.v9_0.getVersionNum()) {
            return;
        }
        int dbVersion = queryExecutor.getServerVersionNum();
        if (dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            SetupQueryRunner.run(queryExecutor, "SET extra_float_digits = 3", false);
        }
        if ((appName = KWProperty.APPLICATION_NAME.get(info)) != null && dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            StringBuilder sql = new StringBuilder();
            sql.append("SET application_name = '");
            Utils.escapeLiteral(sql, appName, queryExecutor.getStandardConformingStrings());
            sql.append("'");
            SetupQueryRunner.run(queryExecutor, sql.toString(), false);
        }
    }

    private boolean isMaster(QueryExecutor queryExecutor) throws SQLException, IOException {
        byte[][] results = SetupQueryRunner.run(queryExecutor, "show transaction_read_only", true);
        String value = queryExecutor.getEncoding().decode(results[0]);
        return value.equalsIgnoreCase("off");
    }
}

