/*
 * Decompiled with CFR 0.152.
 */
package com.kaiwudb.core.v3.replication;

import com.kaiwudb.copy.CopyDual;
import com.kaiwudb.core.KWStream;
import com.kaiwudb.core.QueryExecutor;
import com.kaiwudb.core.ReplicationProtocol;
import com.kaiwudb.core.v3.replication.V3KWReplicationStream;
import com.kaiwudb.replication.KWReplicationStream;
import com.kaiwudb.replication.ReplicationType;
import com.kaiwudb.replication.fluent.CommonOptions;
import com.kaiwudb.replication.fluent.logical.LogicalReplicationOptions;
import com.kaiwudb.replication.fluent.physical.PhysicalReplicationOptions;
import com.kaiwudb.util.GT;
import com.kaiwudb.util.KSQLException;
import com.kaiwudb.util.KSQLState;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class V3ReplicationProtocol
implements ReplicationProtocol {
    private static final Logger LOGGER = Logger.getLogger(V3ReplicationProtocol.class.getName());
    private final QueryExecutor queryExecutor;
    private final KWStream kwStream;

    public V3ReplicationProtocol(QueryExecutor queryExecutor, KWStream kwStream) {
        this.queryExecutor = queryExecutor;
        this.kwStream = kwStream;
    }

    @Override
    public KWReplicationStream startLogical(LogicalReplicationOptions options) throws SQLException {
        String query = this.createStartLogicalQuery(options);
        return this.initializeReplication(query, options, ReplicationType.LOGICAL);
    }

    @Override
    public KWReplicationStream startPhysical(PhysicalReplicationOptions options) throws SQLException {
        String query = this.createStartPhysicalQuery(options);
        return this.initializeReplication(query, options, ReplicationType.PHYSICAL);
    }

    private KWReplicationStream initializeReplication(String query, CommonOptions options, ReplicationType replicationType) throws SQLException {
        LOGGER.log(Level.FINEST, " FE=> StartReplication(query: {0})", query);
        this.configureSocketTimeout(options);
        CopyDual copyDual = (CopyDual)this.queryExecutor.startCopy(query, true);
        return new V3KWReplicationStream(copyDual, options.getStartLSNPosition(), options.getStatusInterval(), replicationType);
    }

    private String createStartPhysicalQuery(PhysicalReplicationOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append("START_REPLICATION");
        if (options.getSlotName() != null) {
            builder.append(" SLOT ").append(options.getSlotName());
        }
        builder.append(" PHYSICAL ").append(options.getStartLSNPosition().asString());
        return builder.toString();
    }

    private String createStartLogicalQuery(LogicalReplicationOptions options) {
        StringBuilder builder = new StringBuilder();
        builder.append("START_REPLICATION SLOT ").append(options.getSlotName()).append(" LOGICAL ").append(options.getStartLSNPosition().asString());
        Properties slotOptions = options.getSlotOptions();
        if (slotOptions.isEmpty()) {
            return builder.toString();
        }
        builder.append(" (");
        boolean isFirst = true;
        for (String name : slotOptions.stringPropertyNames()) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append('\"').append(name).append('\"').append(" ").append('\'').append(slotOptions.getProperty(name)).append('\'');
        }
        builder.append(")");
        return builder.toString();
    }

    private void configureSocketTimeout(CommonOptions options) throws KSQLException {
        if (options.getStatusInterval() == 0) {
            return;
        }
        try {
            int previousTimeOut = this.kwStream.getSocket().getSoTimeout();
            int minimalTimeOut = previousTimeOut > 0 ? Math.min(previousTimeOut, options.getStatusInterval()) : options.getStatusInterval();
            this.kwStream.getSocket().setSoTimeout(minimalTimeOut);
            this.kwStream.setMinStreamAvailableCheckDelay(0);
        }
        catch (IOException ioe) {
            throw new KSQLException(GT.tr("The connection attempt failed.", new Object[0]), KSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
        }
    }
}

